/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ippool.support.http.stat;

import com.alibaba.fastjson.JSONObject;
import com.virjar.dungproxy.client.ippool.support.http.PoolManager;
import com.virjar.dungproxy.client.ippool.support.http.stat.DruidStatServiceMBean;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DrungClientStatService
implements DruidStatServiceMBean {
    private static final Logger LOG = LoggerFactory.getLogger(DrungClientStatService.class);
    public static final String MBEAN_NAME = "com.alibaba.druid:type=DrungClientStatService";
    private static final DrungClientStatService instance = new DrungClientStatService();
    public static final int RESULT_CODE_SUCCESS = 1;
    public static final int RESULT_CODE_ERROR = -1;
    private static final int DEFAULT_PAGE = 1;
    private static final int DEFAULT_PER_PAGE_COUNT = Integer.MAX_VALUE;
    private static final String ORDER_TYPE_DESC = "desc";
    private static final String ORDER_TYPE_ASC = "asc";
    private static final String DEFAULT_ORDER_TYPE = "asc";
    private static final String DEFAULT_ORDERBY = "SQL";
    private PoolManager poolManager = PoolManager.instance;

    private DrungClientStatService() {
    }

    public static DrungClientStatService getInstance() {
        return instance;
    }

    @Override
    public String service(String url) {
        Map<String, String> parameters = DrungClientStatService.getParameters(url);
        if (url.equals("/basic.json")) {
            return DrungClientStatService.returnJSONResult(1, this.poolManager.returnJSONBasicStat());
        }
        if (url.startsWith("/domains.json")) {
            return DrungClientStatService.returnJSONResult(1, this.poolManager.domains());
        }
        if (url.startsWith("domain-") && StringUtils.contains((CharSequence)url, (CharSequence)".json")) {
            String domain = StringUtils.substringBetween((String)url, (String)"domain-", (String)".json");
            return DrungClientStatService.returnJSONResult(1, this.poolManager.domainInfo(domain));
        }
        return DrungClientStatService.returnJSONResult(-1, "Do not support this request, please contact with administrator.");
    }

    public static String returnJSONResult(int resultCode, Object content) {
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("ResultCode", resultCode);
        dataMap.put("Content", content);
        return JSONObject.toJSONString(dataMap);
    }

    public static void registerMBean() {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName(MBEAN_NAME);
            if (!mbeanServer.isRegistered(objectName)) {
                mbeanServer.registerMBean(instance, objectName);
            }
        }
        catch (JMException ex) {
            LOG.error("register mbean error", (Throwable)ex);
        }
    }

    public static void unregisterMBean() {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            mbeanServer.unregisterMBean(new ObjectName(MBEAN_NAME));
        }
        catch (JMException ex) {
            LOG.error("unregister mbean error", (Throwable)ex);
        }
    }

    public static Map<String, String> getParameters(String url) {
        if (url == null || (url = url.trim()).length() == 0) {
            return Collections.emptyMap();
        }
        String parametersStr = StringUtils.substring((String)url, (int)url.indexOf(63));
        if (parametersStr == null || parametersStr.length() == 0) {
            return Collections.emptyMap();
        }
        String[] parametersArray = parametersStr.split("&");
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        for (String parameterStr : parametersArray) {
            int index = parameterStr.indexOf("=");
            if (index <= 0) continue;
            String name = parameterStr.substring(0, index);
            String value = parameterStr.substring(index + 1);
            parameters.put(name, value);
        }
        return parameters;
    }
}

