/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.model;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.virjar.dungproxy.client.ippool.DomainPool;
import com.virjar.dungproxy.client.ippool.IpPool;
import com.virjar.dungproxy.client.ippool.config.DomainContext;
import com.virjar.dungproxy.client.ippool.config.DungProxyContext;
import com.virjar.dungproxy.client.ippool.strategy.Offline;
import com.virjar.dungproxy.client.ippool.strategy.Scoring;
import com.virjar.dungproxy.client.model.AvProxyVO;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.Header;

public class AvProxy {
    private static AtomicLong proxyNumberChange = new AtomicLong(0L);
    private String ip;
    private Integer port;
    private String username;
    private String password;
    private List<Header> authenticationHeaders = Lists.newArrayList();
    private boolean isInit = true;
    private long lastUsedTime = 0L;
    private DomainPool domainPool;
    private boolean disable = false;
    private AtomicInteger referCount = new AtomicInteger(0);
    private AtomicInteger failedCount = new AtomicInteger(0);
    private double avgScore = 0.0;
    private boolean referFlag = false;
    public static boolean needRecordChange = true;
    private DungProxyContext dungProxyContext;
    private Scoring scoring;
    private Offline offline;
    private DomainContext domainContext;
    private long resueTime;

    public AvProxy(DomainContext domainContext) {
        this.domainContext = domainContext;
        this.dungProxyContext = domainContext.getDungProxyContext();
        this.scoring = domainContext.getScoring();
        this.offline = domainContext.getOffline();
        if (needRecordChange) {
            this.recordProxyChange();
        }
    }

    public void recordProxyChange() {
        if (proxyNumberChange.incrementAndGet() % 10L == 0L) {
            if (IpPool.getInstance() == null) {
                return;
            }
            this.dungProxyContext.getAvProxyDumper().serializeProxy(Maps.transformValues(IpPool.getInstance().getPoolInfo(), (Function)new Function<List<AvProxy>, List<AvProxyVO>>(){

                public List<AvProxyVO> apply(List<AvProxy> input) {
                    return Lists.transform(input, (Function)new Function<AvProxy, AvProxyVO>(){

                        public AvProxyVO apply(AvProxy input) {
                            return AvProxyVO.fromModel(input);
                        }
                    });
                }
            }));
        }
    }

    public synchronized void reset() {
        this.referCount.set(0);
        this.failedCount.set(0);
        this.disable = false;
    }

    public void recordFailed() {
        if (!this.referFlag) {
            return;
        }
        this.referFlag = false;
        this.avgScore = this.scoring.newAvgScore(this, this.domainContext.getScoreFactory(), false);
        this.failedCount.incrementAndGet();
        if (this.offline.needOffline(this)) {
            this.offline();
        } else {
            this.domainPool.adjustPriority(this);
        }
    }

    public void adjustPriority() {
        this.domainPool.adjustPriority(this);
    }

    public void recordUsage() {
        if (this.referFlag) {
            this.avgScore = this.scoring.newAvgScore(this, this.domainContext.getScoreFactory(), true);
        }
        this.referFlag = true;
        this.lastUsedTime = System.currentTimeMillis();
        this.referCount.incrementAndGet();
    }

    public void block(long blockTimeStamp) {
        this.domainPool.block(this, blockTimeStamp);
    }

    public void offline(boolean force) {
        if (!force) {
            return;
        }
        if (needRecordChange) {
            this.recordProxyChange();
        }
        this.disable = true;
        this.domainPool.offline(this);
    }

    public void offline() {
        this.offline(true);
    }

    public long getLastUsedTime() {
        return this.lastUsedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvProxy avProxy = (AvProxy)o;
        return this.ip != null ? this.ip.equals(avProxy.ip) : avProxy.ip == null && (this.port != null ? this.port.equals(avProxy.port) : avProxy.port == null);
    }

    public int hashCode() {
        int result = this.ip != null ? this.ip.hashCode() : 0;
        result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
        return result;
    }

    public boolean isDisable() {
        return this.disable;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public boolean isInit() {
        return this.isInit;
    }

    public void setInit(boolean init) {
        this.isInit = init;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public List<Header> getAuthenticationHeaders() {
        return this.authenticationHeaders;
    }

    public void setAuthenticationHeaders(List<Header> authenticationHeaders) {
        this.authenticationHeaders = authenticationHeaders;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public DomainPool getDomainPool() {
        return this.domainPool;
    }

    public void setDomainPool(DomainPool domainPool) {
        this.domainPool = domainPool;
    }

    @Deprecated
    public AvProxy copy() {
        AvProxy newProxy = new AvProxy(this.domainContext);
        newProxy.domainPool = this.domainPool;
        newProxy.disable = this.disable;
        newProxy.ip = this.ip;
        newProxy.isInit = this.isInit;
        newProxy.port = this.port;
        newProxy.failedCount = new AtomicInteger(this.failedCount.get());
        newProxy.referCount = new AtomicInteger(this.referCount.get());
        newProxy.avgScore = this.avgScore;
        return newProxy;
    }

    public Integer getFailedCount() {
        return this.failedCount.get();
    }

    public Integer getReferCount() {
        return this.referCount.get();
    }

    public double getAvgScore() {
        return this.avgScore;
    }

    public void setAvgScore(double avgScore) {
        this.avgScore = avgScore;
    }

    public void setFailedCount(Integer failedCount) {
        this.failedCount = new AtomicInteger(failedCount);
    }

    public void setReferCount(Integer referCount) {
        this.referCount = new AtomicInteger(referCount);
    }

    public long getResueTime() {
        return this.resueTime;
    }

    public void setResueTime(long resueTime) {
        this.resueTime = resueTime;
    }
}

