/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.model;

import com.google.common.collect.Lists;
import com.virjar.dungproxy.client.ippool.DomainPool;
import com.virjar.dungproxy.client.ippool.config.DomainContext;
import com.virjar.dungproxy.client.model.AvProxy;
import com.virjar.dungproxy.client.model.CloudProxy;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;

public class AvProxyVO {
    private String ip;
    private Integer port;
    private Integer referCount = 0;
    private Integer failedCount = 0;
    private double avgScore = 0.0;
    private String domain;
    private Boolean cloud;
    private Integer partnerSize;
    private String username;
    private String password;
    private List<Header> authenticationHeaders = Lists.newArrayList();

    public Boolean getCloud() {
        return this.cloud;
    }

    public void setCloud(Boolean cloud) {
        this.cloud = cloud;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public List<Header> getAuthenticationHeaders() {
        return Lists.newArrayList(this.authenticationHeaders);
    }

    public void setAuthenticationHeaders(List<Header> authenticationHeaders) {
        this.authenticationHeaders = authenticationHeaders;
    }

    public double getAvgScore() {
        return this.avgScore;
    }

    public void setAvgScore(double avgScore) {
        this.avgScore = avgScore;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Integer getFailedCount() {
        return this.failedCount;
    }

    public void setFailedCount(Integer failedCount) {
        this.failedCount = failedCount;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getReferCount() {
        return this.referCount;
    }

    public void setReferCount(Integer referCount) {
        this.referCount = referCount;
    }

    public Integer getPartnerSize() {
        return this.partnerSize;
    }

    public void setPartnerSize(Integer partnerSize) {
        this.partnerSize = partnerSize;
    }

    public AvProxy toModel(DomainContext domainContext) {
        AvProxy avProxy = this.cloud != null && this.cloud != false ? new CloudProxy(domainContext) : new AvProxy(domainContext);
        avProxy.setIp(this.ip);
        avProxy.setPort(this.port);
        avProxy.setAvgScore(this.avgScore);
        avProxy.setReferCount(this.referCount);
        avProxy.setFailedCount(this.failedCount);
        avProxy.setUsername(this.username);
        avProxy.setPassword(this.password);
        avProxy.setAuthenticationHeaders(this.getAuthenticationHeaders());
        return avProxy;
    }

    public List<? extends AvProxy> toPartnerModels(DomainContext domainContext) {
        if (this.cloud == null || !this.cloud.booleanValue()) {
            return Lists.newArrayList((Object[])new AvProxy[]{this.toModel(domainContext)});
        }
        ArrayList cloudProxies = Lists.newArrayList();
        for (int i = 0; i < this.partnerSize; ++i) {
            CloudProxy cloudProxy = (CloudProxy)this.toModel(domainContext);
            cloudProxy.setPartners(cloudProxies);
            cloudProxy.setOffset(i);
            cloudProxies.add(cloudProxy);
        }
        return cloudProxies;
    }

    public AvProxy toModel(DomainPool domainPool) {
        return this.toModel(domainPool.getDomainContext());
    }

    public static AvProxyVO fromModel(AvProxy avProxy) {
        AvProxyVO avProxyVO = new AvProxyVO();
        avProxyVO.setIp(avProxy.getIp());
        avProxyVO.setPort(avProxy.getPort());
        avProxyVO.setFailedCount(avProxy.getFailedCount());
        avProxyVO.setReferCount(avProxy.getReferCount());
        avProxyVO.setAvgScore(avProxy.getAvgScore());
        avProxyVO.setDomain(avProxy.getDomainPool().getDomain());
        avProxyVO.setCloud(avProxy instanceof CloudProxy);
        avProxyVO.setAuthenticationHeaders(avProxy.getAuthenticationHeaders());
        avProxyVO.setUsername(avProxy.getUsername());
        avProxyVO.setPassword(avProxy.getPassword());
        return avProxyVO;
    }
}

