/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ningclient.concurrent;

import com.virjar.dungproxy.client.ningclient.concurrent.ManagedExecutors;
import com.virjar.dungproxy.client.ningclient.concurrent.ManagedThreadPool;
import com.virjar.dungproxy.client.ningclient.concurrent.ThreadRecycles;
import com.virjar.dungproxy.client.ningclient.concurrent.TimeCounter;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedScheduledThreadPool
extends ScheduledThreadPoolExecutor
implements TimeCounter {
    private static final Logger log = LoggerFactory.getLogger(ManagedThreadPool.class);
    private final AtomicLong finishTime = new AtomicLong();
    private static final ThreadLocal<Long> local = new ThreadLocal();

    public ManagedScheduledThreadPool(int corePoolSize) {
        super(corePoolSize, ManagedExecutors.defaultThreadFactory());
    }

    public ManagedScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    public ManagedScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    public ManagedScheduledThreadPool(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, ManagedExecutors.defaultThreadFactory(), handler);
    }

    @Override
    public long getFinishTime() {
        return this.finishTime.get();
    }

    @Override
    public void beforeExecute(Thread t, Runnable r) {
        local.set(System.currentTimeMillis());
        super.beforeExecute(t, r);
        try {
            ThreadRecycles.init();
        }
        catch (RuntimeException var4) {
            log.warn("ThreadRecycles.init error", (Throwable)var4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable ex) {
        try {
            long e = local.get();
            local.remove();
            this.finishTime.addAndGet(System.currentTimeMillis() - e);
        }
        catch (Exception e11) {
            log.error("ThreadLocal.remove() error :", (Throwable)e11);
        }
        try {
            ThreadRecycles.release();
        }
        catch (Exception e9) {
            log.warn("ThreadRecycles.release() error", (Throwable)e9);
        }
        finally {
            super.afterExecute(r, ex);
        }
        if (ex != null) {
            log.warn("\u5728\u7ebf\u7a0b\u6c60\u4e2d\u6355\u83b7\u5230\u672a\u77e5\u5f02\u5e38:", ex);
        }
    }
}

