/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ningclient.concurrent;

import com.virjar.dungproxy.client.ningclient.concurrent.Recyclable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadRecycles {
    private static final Logger log = LoggerFactory.getLogger(ThreadRecycles.class);
    private static final ThreadLocal<ThreadRecycles> local = new ThreadLocal();
    private LinkedHashMap<Object, Recyclable> recycles = new LinkedHashMap();

    public static ThreadRecycles init() {
        ThreadRecycles tlr = local.get();
        if (tlr == null) {
            tlr = new ThreadRecycles();
            local.set(tlr);
        }
        return tlr;
    }

    public static void release() {
        ThreadRecycles current = local.get();
        if (current != null) {
            current.clear();
            local.remove();
        }
    }

    public static Map.Entry<Object, Recyclable>[] recycleSet() {
        ThreadRecycles current = local.get();
        if (current == null) {
            return new Map.Entry[0];
        }
        Map.Entry[] arr = new Map.Entry[current.recycles.size()];
        current.recycles.entrySet().toArray(arr);
        return arr;
    }

    public static void setRecycle(Object key, Recyclable recycle) {
        ThreadRecycles current = local.get();
        if (current == null) {
            current = ThreadRecycles.init();
            log.error("\u7ebf\u7a0b\u56de\u6536\u5668(LocalRecycles)\u672a\u88ab\u6210\u529f\u63a5\u7ba1,\u8bf7\u786e\u5b9a\u5f53\u524d\u8d44\u6e90\u662f\u5728\u5b89\u5168\u7684\u6267\u884c\u73af\u5883(\u7ebf\u7a0b\u6c60)\u4e2d\u88ab\u5f00\u542f." + recycle + ":" + Thread.currentThread());
        }
        current.put(key, recycle);
    }

    public static <E> E getRecycle(Object key) {
        ThreadRecycles current = local.get();
        return (E)(current != null ? current.recycles.get(key) : null);
    }

    public static void removeRecycle(Object key) {
        ThreadRecycles current = local.get();
        if (current != null) {
            current.recycles.remove(key);
        }
    }

    private ThreadRecycles() {
    }

    private void put(Object key, Recyclable recycle) {
        if (this.recycles.containsKey(key)) {
            throw new IllegalStateException("\u91cd\u590d\u7684key:" + key);
        }
        this.recycles.put(key, recycle);
    }

    private void clear() {
        Recyclable[] arr = new Recyclable[this.recycles.size()];
        this.recycles.values().toArray(arr);
        this.recycles.clear();
        for (int i = arr.length - 1; i >= 0; --i) {
            try {
                arr[i].recycle();
                log.warn("\u8d44\u6e90\u56de\u6536\u5668\u6355\u83b7\u5230\u672a\u56de\u6536\u7684\u8d44\u6e90: " + Thread.currentThread() + "|" + arr[i]);
                continue;
            }
            catch (Exception e) {
                log.warn("recycle failed", (Throwable)e);
            }
        }
    }
}

