/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ningclient.conn;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.providers.jdk.JDKAsyncHttpProvider;
import com.ning.http.client.uri.Uri;
import com.virjar.dungproxy.client.ippool.IpPool;
import com.virjar.dungproxy.client.ippool.IpPoolHolder;
import com.virjar.dungproxy.client.model.AvProxy;
import com.virjar.dungproxy.client.ningclient.conn.DungProxyHandler;
import com.virjar.dungproxy.client.ningclient.conn.DungProxyRequest;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DungProxyAsyncHttpProvider
implements AsyncHttpProvider {
    private static final Logger logger = LoggerFactory.getLogger(DungProxyAsyncHttpProvider.class);
    private static final String DEFAULT_PROVIDER = "com.ning.http.client.providers.netty.NettyAsyncHttpProvider";
    private AsyncHttpProvider delegate;
    private IpPool ipPool;

    public DungProxyAsyncHttpProvider() {
        this(null, null);
    }

    public DungProxyAsyncHttpProvider(AsyncHttpProvider asyncHttpProvider, AsyncHttpClientConfig config) {
        if (asyncHttpProvider == null) {
            asyncHttpProvider = DungProxyAsyncHttpProvider.loadDefaultProvider(DEFAULT_PROVIDER, config);
        }
        this.delegate = asyncHttpProvider;
        this.ipPool = IpPoolHolder.getIpPool();
    }

    public DungProxyAsyncHttpProvider(AsyncHttpProvider asyncHttpProvider) {
        this(asyncHttpProvider, null);
    }

    public <T> ListenableFuture<T> execute(Request request, AsyncHandler<T> handler) {
        AvProxy proxy;
        Uri uri = request.getUri();
        if (request.getProxyServer() == null && (proxy = this.ipPool.bind(uri.getHost(), uri.toUrl())) != null) {
            return this.delegate.execute((Request)new DungProxyRequest(request, proxy), new DungProxyHandler<T>(proxy, handler));
        }
        return this.delegate.execute(request, handler);
    }

    public void close() {
        this.delegate.close();
    }

    private static final AsyncHttpProvider loadDefaultProvider(String className, AsyncHttpClientConfig config) {
        try {
            Class<?> providerClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            return (AsyncHttpProvider)providerClass.getDeclaredConstructor(AsyncHttpClientConfig.class).newInstance(config);
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)t;
                if (logger.isErrorEnabled()) {
                    logger.error("Unable to instantiate provider {}.  Trying other providers.", (Object)className);
                    logger.error(ite.getCause().toString(), ite.getCause());
                }
            }
            try {
                Class<?> providerClass = AsyncHttpClient.class.getClassLoader().loadClass(className);
                return (AsyncHttpProvider)providerClass.getDeclaredConstructor(AsyncHttpClientConfig.class).newInstance(config);
            }
            catch (Throwable throwable) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Default provider not found {}. Using the {}", (Object)DEFAULT_PROVIDER, (Object)JDKAsyncHttpProvider.class.getName());
                }
                if (config != null) {
                    return new JDKAsyncHttpProvider(config);
                }
                throw new IllegalStateException("\u4e0d\u652f\u6301\u81ea\u52a8\u4ea7\u751fJDKAsyncHttpProvider \u8bf7\u624b\u52a8\u6ce8\u5165");
            }
        }
    }
}

