/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ningclient.http;

import com.google.common.collect.ImmutableMap;
import com.ning.http.client.ProxyServer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HttpOption {
    public static final int NOTSET = -1;
    private Map<String, String> headers;
    private ProxyServer proxy;
    private Map<String, String> postFormData;
    private String postBodyData;
    private int requestTimeoutInMs = -1;

    public synchronized HttpOption addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
        return this;
    }

    public HttpOption setProxy(String host, int port) {
        this.proxy = new ProxyServer(host, port);
        return this;
    }

    public synchronized Map<String, String> getHeaders() {
        if (this.headers == null) {
            return Collections.emptyMap();
        }
        return ImmutableMap.copyOf(this.headers);
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    public HttpOption addPostFormData(String key, String value) {
        if (this.postFormData == null) {
            this.postFormData = new HashMap<String, String>();
        }
        this.postFormData.put(key, value);
        return this;
    }

    public Map<String, String> getPostFormData() {
        if (this.postFormData == null) {
            return Collections.emptyMap();
        }
        return ImmutableMap.copyOf(this.postFormData);
    }

    public String getPostBodyData() {
        return this.postBodyData;
    }

    public HttpOption setPostBodyData(String postBodyData) {
        this.postBodyData = postBodyData;
        return this;
    }

    public HttpOption withRequestTimeoutInMs(int requestTimeoutInMs) {
        this.requestTimeoutInMs = requestTimeoutInMs;
        return this;
    }

    public int getRequestTimeoutInMs() {
        return this.requestTimeoutInMs;
    }
}

