/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ningclient.proxyclient;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.Response;
import com.virjar.dungproxy.client.ningclient.http.HttpOption;
import com.virjar.dungproxy.client.ningclient.proxyclient.VirjarAsyncClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyClient
extends VirjarAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(ProxyClient.class);

    @Override
    public <T> ListenableFuture<T> get(String url, HttpOption option, AsyncHandler<T> handler) throws IOException {
        return this.privateGet(url, new HttpOption(), handler);
    }

    @Override
    public <T> ListenableFuture<T> get(String url, AsyncHandler<T> handler) throws IOException {
        return this.get(url, new HttpOption(), handler);
    }

    @Override
    public ListenableFuture<Response> getWithoutHandler(String url) throws IOException {
        return this.get(url, new HttpOption(), (AsyncHandler)new AsyncCompletionHandlerBase());
    }

    @Override
    public ListenableFuture<Response> getWithoutHandler(String url, HttpOption option) throws IOException {
        return this.get(url, option, (AsyncHandler)new AsyncCompletionHandlerBase());
    }

    @Override
    public <T> ListenableFuture<List<T>> get(Map<String, AsyncHandler<T>> urlAndHandlers) {
        ListenableFuture[] futures = new ListenableFuture[urlAndHandlers.size()];
        int index = 0;
        for (Map.Entry<String, AsyncHandler<T>> asyncHandlerEntry : urlAndHandlers.entrySet()) {
            String url = asyncHandlerEntry.getKey();
            AsyncHandler<T> handler = asyncHandlerEntry.getValue();
            try {
                futures[index] = this.get(url, handler);
            }
            catch (Exception e) {
                futures[index] = Futures.immediateFailedFuture((Throwable)e);
                log.error("invoke url error,url is {}", (Object)url, (Object)e);
            }
            ++index;
        }
        return Futures.successfulAsList((ListenableFuture[])futures);
    }

    @Override
    public ListenableFuture<List<Response>> get(List<String> urls) {
        HashMap maps = Maps.newHashMapWithExpectedSize((int)urls.size());
        for (String url : urls) {
            maps.put(url, new AsyncCompletionHandlerBase());
        }
        return this.get(maps);
    }

    public <T> ListenableFuture<T> post(String url, Map<String, String> params, String charset, AsyncHandler<T> handler) throws IOException {
        return this.post(url, params, new HttpOption(), charset, handler);
    }

    public <T> ListenableFuture<T> post(String url, Map<String, String> params, HttpOption option, String charset, AsyncHandler<T> handler) throws IOException {
        return this.privatePost(url, params, new HttpOption(), charset, handler);
    }
}

