/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ningclient.proxyclient;

import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Request;
import com.ning.http.client.Response;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.multipart.StringPart;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.virjar.dungproxy.client.ningclient.concurrent.ManagedExecutors;
import com.virjar.dungproxy.client.ningclient.concurrent.NamedThreadFactory;
import com.virjar.dungproxy.client.ningclient.conn.DungProxyAsyncHttpProvider;
import com.virjar.dungproxy.client.ningclient.http.AsyncClientHandler;
import com.virjar.dungproxy.client.ningclient.http.GuavaListenableFuture;
import com.virjar.dungproxy.client.ningclient.http.HttpOption;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PreDestroy;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirjarAsyncClient {
    private static final Logger log;
    private static final Supplier<HashedWheelTimer> TIMER;
    private static final Supplier<NioClientSocketChannelFactory> CHANNEL_FACTORY;
    private final Supplier<AsyncHttpClient> lazyClient = Suppliers.memoize((Supplier)new Supplier<AsyncHttpClient>(){

        public AsyncHttpClient get() {
            VirjarAsyncClient.this.builder.setExecutorService(ManagedExecutors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2, fact));
            NettyAsyncHttpProviderConfig providerConfig = new NettyAsyncHttpProviderConfig();
            providerConfig.setNettyTimer((Timer)TIMER.get());
            if (VirjarAsyncClient.this.shareExecutor) {
                providerConfig.setBossExecutorService((ExecutorService)ManagedExecutors.getExecutor());
                providerConfig.setSocketChannelFactory((NioClientSocketChannelFactory)CHANNEL_FACTORY.get());
            }
            VirjarAsyncClient.this.builder.setAsyncHttpClientProviderConfig((AsyncHttpProviderConfig)providerConfig);
            AsyncHttpClientConfig clientConfig = VirjarAsyncClient.this.builder.build();
            return new AsyncHttpClient((AsyncHttpProvider)new DungProxyAsyncHttpProvider(null, clientConfig), clientConfig);
        }
    });
    private boolean shareExecutor = true;
    private final AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
    private static final ThreadFactory fact;

    public VirjarAsyncClient() {
        this.setCompressionEnabled(true);
        this.setAllowPoolingConnection(true);
        this.setIdleConnectionInPoolTimeoutInMs(60000);
        this.setMaximumConnectionsTotal(100);
        this.setMaximumConnectionsPerHost(20);
        this.setConnectionTimeoutInMs(1000);
        this.setRequestTimeoutInMs(60000);
    }

    @PreDestroy
    public void destroy() {
        if (this.getClient() != null) {
            this.getClient().close();
        }
    }

    <T> ListenableFuture<T> privateGet(String url, HttpOption option, AsyncHandler<T> handler) throws IOException {
        AsyncHttpClient.BoundRequestBuilder builder = this.getClient().prepareGet(url);
        if (option != null) {
            for (Map.Entry<String, String> entry : option.getHeaders().entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
            if (option.getProxy() != null) {
                builder.setProxyServer(option.getProxy());
            }
            if (option.getRequestTimeoutInMs() != -1) {
                builder.setRequestTimeout(option.getRequestTimeoutInMs());
            }
        }
        Request request = builder.build();
        return new GuavaListenableFuture(this.getClient().executeRequest(request, new AsyncClientHandler<T>(handler)));
    }

    private <T> ListenableFuture<T> privatePost(String url, HttpOption option, AsyncHandler<T> handler) throws IOException {
        AsyncHttpClient.BoundRequestBuilder builder = this.getClient().preparePost(url);
        if (option != null) {
            Map<String, String> postFormData = option.getPostFormData();
            Map<String, String> headers = option.getHeaders();
            String body = option.getPostBodyData();
            ProxyServer proxy = option.getProxy();
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    builder.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (postFormData != null && !postFormData.isEmpty()) {
                for (Map.Entry<String, String> entry : postFormData.entrySet()) {
                    builder.addBodyPart((Part)new StringPart(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)body)) {
                builder.setBody(body);
            }
            if (proxy != null) {
                builder.setProxyServer(proxy);
            }
        }
        Request request = builder.build();
        return new GuavaListenableFuture(this.getClient().executeRequest(request, new AsyncClientHandler<T>(handler)));
    }

    <T> ListenableFuture<T> privatePost(String url, Map<String, String> params, HttpOption option, String charset, AsyncHandler<T> handler) throws IOException {
        AsyncHttpClient.BoundRequestBuilder builder = this.getClient().preparePost(url);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            StringPart part = new StringPart(entry.getKey(), entry.getValue(), null, Charset.forName(charset));
            builder.addBodyPart((Part)part);
        }
        if (option != null) {
            for (Map.Entry<String, String> entry : option.getHeaders().entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
            if (option.getProxy() != null) {
                builder.setProxyServer(option.getProxy());
            }
        }
        Request request = builder.build();
        return new GuavaListenableFuture(this.getClient().executeRequest(request, new AsyncClientHandler<T>(handler)));
    }

    public <T> ListenableFuture<T> get(String url, AsyncHandler<T> handler) throws IOException {
        return this.privateGet(url, null, handler);
    }

    public <T> ListenableFuture<T> get(String url, HttpOption option, AsyncHandler<T> handler) throws IOException {
        return this.privateGet(url, option, handler);
    }

    public ListenableFuture<Response> get(String url) throws IOException {
        return this.get(url, (HttpOption)null);
    }

    public ListenableFuture<Response> get(String url, HttpOption option) throws IOException {
        return this.privateGet(url, option, (AsyncHandler)new AsyncCompletionHandlerBase());
    }

    @Deprecated
    public ListenableFuture<Response> getWithoutHandler(String url) throws IOException {
        return this.get(url);
    }

    @Deprecated
    public ListenableFuture<Response> getWithoutHandler(String url, HttpOption option) throws IOException {
        return this.get(url, option);
    }

    public <T> ListenableFuture<List<T>> get(Map<String, AsyncHandler<T>> urlAndHandlers) {
        ListenableFuture[] futures = new ListenableFuture[urlAndHandlers.size()];
        int index = 0;
        for (Map.Entry<String, AsyncHandler<T>> asyncHandlerEntry : urlAndHandlers.entrySet()) {
            String url = asyncHandlerEntry.getKey();
            AsyncHandler<T> handler = asyncHandlerEntry.getValue();
            try {
                futures[index] = this.get(url, handler);
            }
            catch (Exception e) {
                futures[index] = Futures.immediateFailedFuture((Throwable)e);
                log.error("invoke url error,url is {}", (Object)url, (Object)e);
            }
            ++index;
        }
        return Futures.successfulAsList((ListenableFuture[])futures);
    }

    public ListenableFuture<List<Response>> get(List<String> urls) {
        HashMap maps = Maps.newHashMapWithExpectedSize((int)urls.size());
        for (String url : urls) {
            maps.put(url, new AsyncCompletionHandlerBase());
        }
        return this.get(maps);
    }

    public <T> ListenableFuture<T> post(String url, HttpOption option, AsyncHandler<T> handler) throws IOException {
        return this.privatePost(url, option, handler);
    }

    public ListenableFuture<Response> post(String url, HttpOption option) throws IOException {
        return this.privatePost(url, option, (AsyncHandler)new AsyncCompletionHandler<Response>(){

            public Response onCompleted(Response response) throws Exception {
                return response;
            }
        });
    }

    public void setCompressionEnabled(boolean compressionEnabled) {
        this.builder.setCompressionEnforced(compressionEnabled);
    }

    public void setAllowPoolingConnection(boolean allowPoolingConnection) {
        this.builder.setAllowPoolingConnections(allowPoolingConnection);
    }

    public void setIdleConnectionInPoolTimeoutInMs(int defaultIdleConnectionInPoolTimeoutInMs) {
        this.builder.setPooledConnectionIdleTimeout(defaultIdleConnectionInPoolTimeoutInMs);
    }

    public void setMaximumConnectionsTotal(int defaultMaxTotalConnections) {
        this.builder.setMaxConnections(defaultMaxTotalConnections);
    }

    public void setMaximumConnectionsPerHost(int defaultMaxConnectionPerHost) {
        this.builder.setMaxConnectionsPerHost(defaultMaxConnectionPerHost);
    }

    public void setConnectionTimeoutInMs(int defaultConnectionTimeOutInMs) {
        this.builder.setConnectTimeout(defaultConnectionTimeOutInMs);
    }

    public void setRequestTimeoutInMs(int defaultRequestTimeoutInMs) {
        this.builder.setRequestTimeout(defaultRequestTimeoutInMs);
    }

    private static void check() {
        try {
            Class.forName("org.jboss.netty.bootstrap.ClientBootstrap");
        }
        catch (ClassNotFoundException e) {
            String message = "\u4f7f\u7528 VirjarAsyncClient \u5fc5\u987b\u5f15\u5165io.netty:netty all in one\u5305.";
            log.error(message);
            throw new RuntimeException(message);
        }
    }

    public AsyncHttpClient getClient() {
        return (AsyncHttpClient)this.lazyClient.get();
    }

    static {
        VirjarAsyncClient.check();
        log = LoggerFactory.getLogger(VirjarAsyncClient.class);
        TIMER = Suppliers.memoize((Supplier)new Supplier<HashedWheelTimer>(){

            public HashedWheelTimer get() {
                HashedWheelTimer timer = new HashedWheelTimer();
                timer.start();
                return timer;
            }
        });
        CHANNEL_FACTORY = Suppliers.memoize((Supplier)new Supplier<NioClientSocketChannelFactory>(){

            public NioClientSocketChannelFactory get() {
                return new NioClientSocketChannelFactory((Executor)ManagedExecutors.getExecutor(), (Executor)ManagedExecutors.getExecutor(), Runtime.getRuntime().availableProcessors());
            }
        });
        fact = new NamedThreadFactory("hc-nio");
    }
}

