/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;

public class CharsetDetector {
    public static String detectHeader(Header[] headers) {
        if (headers == null || headers.length == 0) {
            return null;
        }
        for (Header header : headers) {
            String s = CharsetDetector.parseContentType(header.getValue());
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            return s;
        }
        return null;
    }

    public static String detectHeader(Header header) {
        if (header == null) {
            return null;
        }
        String s = CharsetDetector.parseContentType(header.getValue());
        if (!StringUtils.isEmpty((CharSequence)s)) {
            return s;
        }
        return null;
    }

    public static String[] substringsBetween(byte[] str, byte[] open, byte[] close) {
        int end;
        int start;
        if (str == null || open == null || close == null) {
            return null;
        }
        int strLen = str.length;
        if (strLen == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int closeLen = close.length;
        int openLen = open.length;
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        while (pos < strLen - closeLen && (start = CharsetDetector.indexOf(str, 0, str.length, open, 0, open.length, pos)) >= 0 && (end = CharsetDetector.indexOf(str, 0, str.length, close, 0, close.length, start += openLen)) >= 0) {
            list.add(new String(Arrays.copyOfRange(str, start, end)));
            pos = end + closeLen;
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    private static int indexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public static String detectHtmlContent(byte[] content) {
        String[] metas = CharsetDetector.substringsBetween(content, "<meta".getBytes(), ">".getBytes());
        if (metas == null) {
            return null;
        }
        for (String meta : metas) {
            int i;
            String substring;
            int end;
            if (meta.toLowerCase().contains("Content-Type".toLowerCase())) {
                String contentType = CharsetDetector.parseContentType(StringUtils.substringBetween((String)meta, (String)"content=\"", (String)"\""));
                if (contentType == null) continue;
                return contentType;
            }
            if (!meta.contains("charset=\"") || (end = (substring = meta.substring((i = meta.indexOf("charset=\"")) + 9)).indexOf("\"")) <= 0) continue;
            return substring.substring(0, end);
        }
        return null;
    }

    private static String parseContentType(String contentType) {
        int separator;
        if (StringUtils.isEmpty((CharSequence)contentType)) {
            return null;
        }
        int charset = (contentType = contentType.toLowerCase()).indexOf("charset");
        if (charset < 0) {
            return null;
        }
        if ((contentType = contentType.substring(charset + 7).trim()).startsWith("=")) {
            contentType = contentType.substring(1);
        }
        if ((separator = contentType.indexOf(";")) < 0) {
            return contentType;
        }
        contentType = contentType.substring(0, contentType.length() - 1);
        return contentType;
    }
}

