/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.util;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtil {
    private static Pattern domainPattern = Pattern.compile("://([^/]+)");
    private static Pattern ipPattern = Pattern.compile("^([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){3}$");
    private static Pattern ipAndPortPattern = Pattern.compile("([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){3}:\\d{1,6}");
    private static final Logger logger = LoggerFactory.getLogger(CommonUtil.class);
    private static Date startTime;

    public static String extractDomain(String url) {
        Matcher matcher;
        if (StringUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        if (!url.startsWith("http")) {
            url = "http://" + url;
        }
        if ((matcher = domainPattern.matcher(url)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static void sleep(long timestamp) {
        try {
            Thread.sleep(timestamp);
        }
        catch (InterruptedException e) {
            logger.error("thread sleep error", (Throwable)e);
        }
    }

    public static <T> void waitAllFutures(List<Future<T>> futureList) {
        for (Future<T> future : futureList) {
            try {
                future.get();
            }
            catch (Exception e) {
                logger.error("error when wait future task", (Throwable)e);
            }
        }
    }

    public static String ensurePathExist(String fileName) throws IOException {
        File parentFile = new File(fileName).getParentFile();
        if (parentFile.exists() && parentFile.isFile()) {
            throw new IOException("can not create directory for file:" + fileName + " it already exist ,and it`s a file");
        }
        if (parentFile.exists() && parentFile.isDirectory()) {
            return fileName;
        }
        if (!parentFile.mkdirs()) {
            throw new IOException("can not create directory for file:" + fileName);
        }
        return fileName;
    }

    public static boolean isIPAddress(String ipAddress) {
        if (StringUtils.isEmpty((CharSequence)ipAddress)) {
            return false;
        }
        Matcher matcher = ipPattern.matcher(ipAddress);
        return matcher.matches();
    }

    public static boolean isPlainProxyItem(String ipAndPort) {
        return ipAndPortPattern.matcher(ipAndPort).find();
    }

    public static String toString(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static final Date getStartTime() {
        if (startTime == null) {
            startTime = new Date(ManagementFactory.getRuntimeMXBean().getStartTime());
        }
        return startTime;
    }

    public static String safeToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }
}

