/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.util;

import com.virjar.dungproxy.client.httpclient.HttpInvoker;
import com.virjar.dungproxy.client.model.AvProxy;
import com.virjar.dungproxy.client.model.AvProxyVO;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpAvValidator {
    private static final Logger logger = LoggerFactory.getLogger(IpAvValidator.class);
    private static InetAddress localAddr;

    private static void init() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                Enumeration<InetAddress> localAddrs = ni.getInetAddresses();
                while (localAddrs.hasMoreElements()) {
                    InetAddress tmp = localAddrs.nextElement();
                    if (tmp.isLoopbackAddress() || tmp.isLinkLocalAddress() || tmp instanceof Inet6Address) continue;
                    localAddr = tmp;
                    logger.info("local IP:" + localAddr.getHostAddress());
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.error("Failure when init ProxyUtil", (Throwable)e);
            logger.error("choose NetworkInterface\n" + IpAvValidator.getNetworkInterface());
        }
    }

    public static boolean available(AvProxyVO avProxy, String testUrl) {
        for (int i = 0; i < 3; ++i) {
            if (HttpInvoker.getStatus(testUrl, avProxy.getIp(), avProxy.getPort()) != 200) continue;
            return true;
        }
        return false;
    }

    public static boolean available(AvProxy avProxy, String testUrl) {
        for (int i = 0; i < 3; ++i) {
            if (HttpInvoker.getStatus(testUrl, avProxy.getIp(), avProxy.getPort()) != 200) continue;
            return true;
        }
        return false;
    }

    private static Socket newLocalSocket() {
        for (int i = 0; i < 3; ++i) {
            Socket socket = new Socket();
            try {
                socket.bind(new InetSocketAddress(localAddr, 0));
                return socket;
            }
            catch (IOException e) {
                logger.warn("\u7cfb\u7edf\u8d44\u6e90\u4e0d\u8db3,\u672c\u5730\u7aef\u53e3\u5f00\u542f\u5931\u8d25");
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                continue;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateProxyConnect(HttpHost p) {
        if (localAddr == null) {
            logger.error("cannot get local ip");
            throw new IllegalStateException("cannot get local ip");
        }
        Socket socket = IpAvValidator.newLocalSocket();
        if (socket == null) {
            return false;
        }
        try {
            InetSocketAddress endpointSocketAddr = new InetSocketAddress(p.getAddress().getHostAddress(), p.getPort());
            socket.connect(endpointSocketAddr, 4000);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            IOUtils.closeQuietly((Socket)socket);
        }
        return false;
    }

    private static String getNetworkInterface() {
        String networkInterfaceName = "";
        Enumeration<NetworkInterface> enumeration = null;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            networkInterfaceName = networkInterfaceName + networkInterface.toString() + '\n';
            Enumeration<InetAddress> addr = networkInterface.getInetAddresses();
            while (addr.hasMoreElements()) {
                networkInterfaceName = networkInterfaceName + "\tip:" + addr.nextElement().getHostAddress() + "\n";
            }
        }
        return networkInterfaceName;
    }

    static {
        IpAvValidator.init();
    }
}

