/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.util;

import com.virjar.dungproxy.client.model.AvProxy;
import org.apache.http.client.protocol.HttpClientContext;

public class PoolUtil {
    public static void recordFailed(HttpClientContext httpClientContext) {
        if (httpClientContext == null) {
            return;
        }
        AvProxy attribute = (AvProxy)httpClientContext.getAttribute("USED_PROXY_KEY", AvProxy.class);
        if (attribute != null) {
            attribute.recordFailed();
        }
    }

    public static void offline(HttpClientContext httpClientContext) {
        if (httpClientContext == null) {
            return;
        }
        AvProxy attribute = (AvProxy)httpClientContext.getAttribute("USED_PROXY_KEY", AvProxy.class);
        if (attribute != null) {
            httpClientContext.removeAttribute("USED_PROXY_KEY");
            attribute.recordFailed();
            attribute.offline();
        }
    }

    public static void cleanProxy(HttpClientContext httpClientContext) {
        httpClientContext.removeAttribute("USED_PROXY_KEY");
    }

    public static void bindUserKey(HttpClientContext httpClientContext, String userId) {
        httpClientContext.setAttribute("DUNGPROXY_USER_KEY", (Object)userId);
    }

    public static AvProxy getBindProxy(HttpClientContext httpClientContext) {
        return (AvProxy)httpClientContext.getAttribute("USED_PROXY_KEY", AvProxy.class);
    }

    public static void disableDungProxy(HttpClientContext httpClientContext) {
        httpClientContext.setAttribute("DISABLE_DUNGPROXY_KEY", (Object)Boolean.TRUE);
    }

    public static boolean isDungProxyEnabled(HttpClientContext httpClientContext) {
        Object attribute = httpClientContext.getAttribute("DISABLE_DUNGPROXY_KEY");
        return attribute == null || !Boolean.TRUE.equals(attribute);
    }
}

