/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtil {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesUtil.class);
    private static final int RELOAD_INTERVAL_SECONDS = 60;
    private static Properties properties = new Properties();
    private static final String[] DEFAULT_PROPERTIES_URL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadFile(String fileUrl) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileUrl);
        try {
            logger.info("\u91cd\u65b0\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6");
            properties.load(is);
        }
        catch (IOException e) {
            logger.error("IOException when load" + fileUrl, (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error("IOException when close inputStream " + fileUrl, (Throwable)e);
            }
        }
    }

    private static void startDeamon() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TimeUnit.SECONDS.sleep(60L);
                    for (String url : DEFAULT_PROPERTIES_URL) {
                        PropertiesUtil.loadFile(url);
                    }
                }
                catch (InterruptedException e) {
                    logger.error("properties-deamon-thread Interrupted", (Throwable)e);
                }
            }
        }, "properties-deamon-thread");
        t.setDaemon(true);
        t.start();
    }

    public static String getProperty(String key) {
        return PropertiesUtil.getProperty(key, null);
    }

    public static synchronized String getProperty(String key, String defaultValue) {
        return properties.getProperty(key) == null ? defaultValue : properties.getProperty(key);
    }

    static {
        for (String url : DEFAULT_PROPERTIES_URL = new String[]{"proxyclient.properties"}) {
            PropertiesUtil.loadFile(url);
        }
        PropertiesUtil.startDeamon();
    }
}

