/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.util;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectUtil {
    public static void addField(Object obj, String key, Object value) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = obj.getClass().getDeclaredField(key);
        field.setAccessible(true);
        field.set(obj, value);
    }

    public static <T> T getField(Object obj, String key) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = obj.getClass();
        Field field = null;
        while (true) {
            try {
                field = clazz.getDeclaredField(key);
                field.setAccessible(true);
                return (T)field.get(obj);
            }
            catch (NoSuchFieldException e) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                return null;
            }
            break;
        }
    }

    public static <T> T invoke(Object obj, String methodName, Class[] clazzList, Object[] args) {
        Preconditions.checkState((clazzList.length == args.length ? 1 : 0) != 0, (Object)"\u53c2\u6570\u7b7e\u540d\u548c\u53c2\u6570\u6570\u76ee\u4e0d\u4e00\u81f4");
        Class<?> clazz = obj.getClass();
        Method method = null;
        do {
            try {
                method = clazz.getMethod(methodName, clazzList);
                return (T)method.invoke(obj, args);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(obj.getClass() + ":\u8c03\u7528\u65b9\u6cd5:" + methodName + "\u5931\u8d25");
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        throw new IllegalStateException(obj.getClass() + ":\u627e\u4e0d\u5230\u65b9\u6cd5:" + methodName);
    }

    public static boolean hasMethod(Object obj, String methodName) {
        Method[] methods;
        for (Method method : methods = obj.getClass().getMethods()) {
            if (!method.getName().equalsIgnoreCase(methodName)) continue;
            return true;
        }
        return false;
    }
}

