/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.stream.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.helper.Utils;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.stream.CommonPo;
import com.volcengine.model.stream.SdkMonitorRequest;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.stream.MonitorConfig;
import com.volcengine.service.stream.MonitorService;
import com.volcengine.service.stream.StreamConfig;
import com.volcengine.service.stream.impl.StreamServiceImpl;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;

public class MonitorServiceImpl
extends BaseServiceImpl
implements MonitorService {
    ThreadPoolExecutor threadPool;
    private static volatile MonitorServiceImpl instance = null;

    private MonitorServiceImpl() {
        super(StreamConfig.serviceInfo, MonitorConfig.apiInfoList);
        int availProcessors = Runtime.getRuntime().availableProcessors();
        this.threadPool = new ThreadPoolExecutor(2 * availProcessors + 1, 5 * availProcessors + 1, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());
    }

    private MonitorServiceImpl(HttpHost proxy) {
        super(StreamConfig.serviceInfo, proxy, MonitorConfig.apiInfoList);
        int availProcessors = Runtime.getRuntime().availableProcessors();
        this.threadPool = new ThreadPoolExecutor(2 * availProcessors + 1, 5 * availProcessors + 1, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MonitorService getInstance(String ak, String sk, HttpHost proxy) {
        if (instance != null) return instance;
        Class<StreamServiceImpl> clazz = StreamServiceImpl.class;
        synchronized (StreamServiceImpl.class) {
            if (instance != null) return instance;
            instance = proxy != null ? new MonitorServiceImpl(proxy) : new MonitorServiceImpl();
            instance.setAccessKey(ak);
            instance.setSecretKey(sk);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void monitor(String partner, String category, String accessToken, String action, int httpCode, int topRespCode, byte[] respData, long latency) {
        boolean needSendMonitor = false;
        SdkMonitorRequest req = new SdkMonitorRequest();
        req.setPartner(partner);
        req.setCategory(category);
        req.setAccessToken(accessToken);
        req.setTimestamp(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
        if (respData != null) {
            Map respMap = (Map)JSON.parseObject((String)new String(respData), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            respMap.remove("Result");
            req.setRespData(JSON.toJSONString((Object)respMap));
            CommonPo.ResponseMetadata responseMetadata = (CommonPo.ResponseMetadata)JSONObject.parseObject((String)((String)respMap.get("ResponseMetadata")), CommonPo.ResponseMetadata.class);
            if (responseMetadata != null && responseMetadata.getError() != null && responseMetadata.getError().getCodeN() != 0L) {
                needSendMonitor = true;
            }
        }
        req.setOriginalAction(action);
        req.setHttpCode(httpCode == 0 ? 200L : (long)httpCode);
        if (httpCode != 0) {
            needSendMonitor = true;
        }
        req.setTopRespCode(topRespCode);
        req.setLatency(latency);
        if (latency >= 800L) {
            needSendMonitor = true;
        }
        if (needSendMonitor) {
            this.threadPool.submit(() -> {
                try {
                    RawResponse rawResponse = this.query("SdkMonitor", Utils.mapToPairList(Utils.paramsToMap(req)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }
}

