/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.config.AbstractConfig;
import com.weibo.api.motan.config.ExtConfig;
import com.weibo.api.motan.config.MethodConfig;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.RegistryConfig;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.registry.RegistryService;
import com.weibo.api.motan.rpc.ApplicationInfo;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.NetUtils;
import com.weibo.api.motan.util.ReflectUtil;
import com.weibo.api.motan.util.UrlUtils;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AbstractInterfaceConfig
extends AbstractConfig {
    private static final long serialVersionUID = 4776516803466933310L;
    protected List<ProtocolConfig> protocols;
    protected List<RegistryConfig> registries;
    protected ExtConfig extConfig;
    protected String application;
    protected String module;
    protected String group;
    protected String version;
    protected String proxy;
    protected String filter;
    protected Integer actives;
    protected Boolean async;
    protected String mock;
    protected Boolean shareChannel;
    protected Boolean throwException;
    protected Integer requestTimeout;
    protected Boolean register;
    protected String accessLog;
    protected String check;
    protected Integer retries;
    protected Boolean usegz;
    protected Integer mingzSize;
    protected String codec;
    protected String localServiceAddress;

    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getAccessLog() {
        return this.accessLog;
    }

    public void setAccessLog(String accessLog) {
        this.accessLog = accessLog;
    }

    public List<RegistryConfig> getRegistries() {
        return this.registries;
    }

    public void setRegistries(List<RegistryConfig> registries) {
        this.registries = registries;
    }

    public ExtConfig getExtConfig() {
        return this.extConfig;
    }

    public void setExtConfig(ExtConfig extConfig) {
        this.extConfig = extConfig;
    }

    public void setRegistry(RegistryConfig registry) {
        this.registries = Collections.singletonList(registry);
    }

    public Integer getActives() {
        return this.actives;
    }

    public void setActives(Integer actives) {
        this.actives = actives;
    }

    public Boolean getAsync() {
        return this.async;
    }

    public void setAsync(Boolean async) {
        this.async = async;
    }

    public String getMock() {
        return this.mock;
    }

    public void setMock(String mock) {
        this.mock = mock;
    }

    public String getCheck() {
        return this.check;
    }

    public void setCheck(String check) {
        this.check = check;
    }

    @Deprecated
    public void setCheck(Boolean check) {
        this.check = String.valueOf(check);
    }

    public Boolean getShareChannel() {
        return this.shareChannel;
    }

    public void setShareChannel(Boolean shareChannel) {
        this.shareChannel = shareChannel;
    }

    public List<ProtocolConfig> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<ProtocolConfig> protocols) {
        this.protocols = protocols;
    }

    public void setProtocol(ProtocolConfig protocol) {
        this.protocols = Collections.singletonList(protocol);
    }

    public Boolean getThrowException() {
        return this.throwException;
    }

    public void setThrowException(Boolean throwException) {
        this.throwException = throwException;
    }

    public Integer getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public boolean hasProtocol() {
        return this.protocols != null && !this.protocols.isEmpty();
    }

    public Boolean getRegister() {
        return this.register;
    }

    public void setRegister(Boolean register) {
        this.register = register;
    }

    public String getLocalServiceAddress() {
        return this.localServiceAddress;
    }

    public void setLocalServiceAddress(String localServiceAddress) {
        this.localServiceAddress = localServiceAddress;
    }

    public Boolean getUsegz() {
        return this.usegz;
    }

    public void setUsegz(Boolean usegz) {
        this.usegz = usegz;
    }

    public Integer getMingzSize() {
        return this.mingzSize;
    }

    public void setMingzSize(Integer mingzSize) {
        this.mingzSize = mingzSize;
    }

    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    protected List<URL> loadRegistryUrls() {
        ArrayList<URL> registryList = new ArrayList<URL>();
        if (this.registries != null && !this.registries.isEmpty()) {
            for (RegistryConfig config : this.registries) {
                List<URL> urls;
                String address = config.getAddress();
                if (StringUtils.isBlank((CharSequence)address)) {
                    address = "127.0.0.1:0";
                }
                HashMap<String, String> map = new HashMap<String, String>();
                config.appendConfigParams(map);
                map.put(URLParamType.application.getName(), this.getApplication());
                map.put(URLParamType.path.getName(), RegistryService.class.getName());
                map.put(URLParamType.refreshTimestamp.getName(), String.valueOf(System.currentTimeMillis()));
                if (!map.containsKey(URLParamType.protocol.getName())) {
                    if (address.contains("://")) {
                        map.put(URLParamType.protocol.getName(), address.substring(0, address.indexOf("://")));
                    }
                    map.put(URLParamType.protocol.getName(), "local");
                }
                if ((urls = UrlUtils.parseURLs(address, map)) == null || urls.isEmpty()) continue;
                for (URL url : urls) {
                    url.removeParameter(URLParamType.protocol.getName());
                    registryList.add(url);
                }
            }
        }
        return registryList;
    }

    protected void checkInterfaceAndMethods(Class<?> interfaceClass, List<MethodConfig> methods) {
        if (interfaceClass == null) {
            throw new IllegalStateException("interface not allow null!");
        }
        if (!interfaceClass.isInterface()) {
            throw new IllegalStateException("The interface class " + interfaceClass + " is not a interface!");
        }
        if (methods != null && !methods.isEmpty()) {
            for (MethodConfig methodBean : methods) {
                String methodName = methodBean.getName();
                if (methodName == null || methodName.length() == 0) {
                    throw new IllegalStateException("<motan:method> name attribute is required! Please check: <motan:service interface=\"" + interfaceClass.getName() + "\" ... ><motan:method name=\"\" ... /></<motan:referer>");
                }
                Method hasMethod = null;
                for (Method method : interfaceClass.getMethods()) {
                    if (!method.getName().equals(methodName)) continue;
                    if (methodBean.getArgumentTypes() != null && ReflectUtil.getMethodParamDesc(method).equals(methodBean.getArgumentTypes())) {
                        hasMethod = method;
                        break;
                    }
                    if (methodBean.getArgumentTypes() != null) continue;
                    if (hasMethod != null) {
                        throw new MotanFrameworkException("The interface " + interfaceClass.getName() + " has more than one method " + methodName + " , must set argumentTypes attribute.", MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
                    }
                    hasMethod = method;
                }
                if (hasMethod == null) {
                    throw new MotanFrameworkException("The interface " + interfaceClass.getName() + " not found method " + methodName, MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
                }
                methodBean.setArgumentTypes(ReflectUtil.getMethodParamDesc(hasMethod));
            }
        }
    }

    protected String getLocalHostAddress(List<URL> registryURLs) {
        String localAddress = null;
        HashMap<String, Integer> regHostPorts = new HashMap<String, Integer>();
        for (URL ru : registryURLs) {
            if (!StringUtils.isNotBlank((CharSequence)ru.getHost()) || ru.getPort() <= 0) continue;
            regHostPorts.put(ru.getHost(), ru.getPort());
        }
        InetAddress address = NetUtils.getLocalAddress(regHostPorts);
        if (address != null) {
            localAddress = address.getHostAddress();
        }
        if (NetUtils.isValidLocalHost(localAddress)) {
            return localAddress;
        }
        throw new MotanServiceException("Please config local server hostname with intranet IP first!", MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
    }

    protected void initLocalAppInfo(URL localUrl) {
        ApplicationInfo.addService(localUrl);
    }
}

