/*
 * Decompiled with CFR 0.152.
 */
package com.wgd.gdcp.gdcplibrary;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class GDBitmapUtil {
    public static int[] getBitmapWH(String path) {
        int[] whSize = new int[2];
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inSampleSize = 1;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        whSize[0] = options.outWidth;
        whSize[1] = options.outHeight;
        return whSize;
    }

    public static File saveBitmapFile(Bitmap bitmap, String filepath) {
        File file = new File(filepath);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static void saveBitmapFileVo(Bitmap bitmap, String filepath) throws Exception {
        File file = new File(filepath);
        if (!file.exists()) {
            file = new File(filepath);
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
        bos.flush();
        bos.close();
    }

    public static Bitmap bitmapDegree(Context mContext, String path) throws Exception {
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeFile((String)path);
        }
        catch (Exception e) {
            bitmap = GDBitmapUtil.adjustImage(mContext, path, 2);
        }
        boolean isRotate = false;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            Matrix matrix = new Matrix();
            int angle = 0;
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    angle = 90;
                    isRotate = true;
                    break;
                }
                case 3: {
                    angle = 180;
                    isRotate = true;
                    break;
                }
                case 8: {
                    angle = 270;
                    isRotate = true;
                }
            }
            matrix.postRotate((float)angle);
            if (isRotate) {
                return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            }
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return bitmap;
        }
    }

    private static Bitmap adjustImage(Context mContext, String absolutePath, int size) {
        Bitmap bm = null;
        BitmapFactory.Options opt = new BitmapFactory.Options();
        opt.inJustDecodeBounds = true;
        int picWidth = opt.outWidth;
        int picHeight = opt.outHeight;
        WindowManager windowManager = ((Activity)mContext).getWindowManager();
        Display display = windowManager.getDefaultDisplay();
        int screenWidth = display.getWidth();
        int screenHeight = display.getHeight();
        opt.inSampleSize = 1;
        if (picWidth > picHeight) {
            if (picWidth > screenWidth) {
                opt.inSampleSize = picWidth / screenWidth;
            }
        } else if (picHeight > screenHeight) {
            opt.inSampleSize = picHeight / screenHeight;
        }
        if (opt.inSampleSize <= 1) {
            opt.inSampleSize = size;
        }
        opt.inJustDecodeBounds = false;
        try {
            bm = BitmapFactory.decodeFile((String)absolutePath, (BitmapFactory.Options)opt);
        }
        catch (Exception e) {
            bm = GDBitmapUtil.adjustImage(mContext, absolutePath, size + 1);
        }
        return bm;
    }

    public static void saveBitmapDegree(String path) {
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            Matrix matrix = new Matrix();
            int angle = 0;
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    angle = 90;
                    break;
                }
                case 3: {
                    angle = 180;
                    break;
                }
                case 8: {
                    angle = 270;
                }
            }
            matrix.postRotate((float)angle);
            if (angle != 0) {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                Bitmap bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
                File saveBitmapFile = GDBitmapUtil.saveBitmapFile(Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true), path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Bitmap getBitmap(String path) {
        try {
            return BitmapFactory.decodeFile((String)path);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.i((String)"GDCimage", (String)"getBitmap: ==============02==============");
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inSampleSize = 2;
            Log.i((String)"GDCimage", (String)"getBitmap: ==============01==============");
            return BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        }
    }
}

