/*
 * Decompiled with CFR 0.152.
 */
package com.wgd.gdcp.gdcplibrary;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.wgd.gdcp.gdcplibrary.GDBitmapUtil;
import com.wgd.gdcp.gdcplibrary.GDCompressImageListener;
import com.wgd.gdcp.gdcplibrary.ImageUtils;
import com.wgd.gdcp.gdcplibrary.thread.ThreadManager;

public class GDCompress {
    private Context mContext;
    private GDCompressImageListener mGDCompressImageListener;
    private String mPath;
    private String savePath;
    private Bitmap bitmap;

    public GDCompress(Context context, String path, String savepath, GDCompressImageListener GDCompressImageListener2) {
        this.mContext = context;
        this.mPath = path;
        this.savePath = savepath;
        this.mGDCompressImageListener = GDCompressImageListener2;
        this.startCompress();
    }

    private void startCompress() {
        ThreadManager.getIO().execute(new Runnable(){

            @Override
            public void run() {
                if (GDCompress.this.compressLibJpeg(GDCompress.this.mPath)) {
                    GDCompress.this.InformCallSuccess(GDCompress.this.savePath);
                } else {
                    GDCompress.this.InformCallError(0, "Image compression failure!");
                }
            }
        });
    }

    private void InformCallSuccess(final String path) {
        block7: {
            try {
                GDBitmapUtil.saveBitmapDegree(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.bitmap != null && !this.bitmap.isRecycled()) {
                    this.bitmap.recycle();
                    this.bitmap = null;
                }
                System.gc();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                ((Activity)this.mContext).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (null != GDCompress.this.mGDCompressImageListener) {
                            GDCompress.this.mGDCompressImageListener.OnSuccess(path);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                if (null == this.mGDCompressImageListener) break block7;
                this.mGDCompressImageListener.OnSuccess(path);
            }
        }
    }

    private void InformCallError(final int code, final String errorMsg) {
        block2: {
            try {
                ((Activity)this.mContext).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (null != GDCompress.this.mGDCompressImageListener) {
                            GDCompress.this.mGDCompressImageListener.OnError(code, errorMsg);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                if (null == this.mGDCompressImageListener) break block2;
                this.mGDCompressImageListener.OnError(code, errorMsg);
            }
        }
    }

    private boolean compressLibJpeg(Bitmap bitmap, int quality) {
        try {
            if (null == this.savePath || TextUtils.equals((CharSequence)"", (CharSequence)this.savePath)) {
                this.savePath = this.mPath;
            }
            if (null == bitmap) {
                return false;
            }
            boolean codeString = ImageUtils.compressBitmap(bitmap, bitmap.getWidth(), bitmap.getHeight(), this.savePath, quality);
            return codeString;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean compressLibJpeg(String path) {
        try {
            this.bitmap = BitmapFactory.decodeFile((String)path);
            return this.compressLibJpeg(this.bitmap, 20);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean compressLibJpeg(String path, int quality) {
        try {
            this.bitmap = BitmapFactory.decodeFile((String)path);
            return this.compressLibJpeg(this.bitmap, quality);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

