/*
 * Decompiled with CFR 0.152.
 */
package com.wgd.gdcp.gdcplibrary;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.wgd.gdcp.gdcplibrary.GDBitmapUtil;
import com.wgd.gdcp.gdcplibrary.GDCompressImageListenerA;
import com.wgd.gdcp.gdcplibrary.GDCompressUtil;
import com.wgd.gdcp.gdcplibrary.GDConfig;
import com.wgd.gdcp.gdcplibrary.GDImageBean;
import com.wgd.gdcp.gdcplibrary.GDTools;
import com.wgd.gdcp.gdcplibrary.thread.ThreadManager;

public class GDCompressA {
    private Context mContext;
    private GDCompressImageListenerA mGDCompressImageListener;
    Bitmap bitmapMin = null;

    public GDCompressA(Context context, GDCompressImageListenerA mGDCompressImageListener) {
        this.mContext = context;
        this.mGDCompressImageListener = mGDCompressImageListener;
    }

    public GDCompressA(Context context, GDImageBean mGDImageBean, GDCompressImageListenerA mGDCompressImageListener) {
        this.mContext = context;
        this.mGDCompressImageListener = mGDCompressImageListener;
        this.start(mGDImageBean);
    }

    public void start(GDImageBean mGDImageBean) {
        GDConfig gdConfig = null;
        if (null != mGDImageBean) {
            gdConfig = mGDImageBean.getmGDConfig();
        }
        if (null == gdConfig) {
            gdConfig = new GDConfig();
        }
        if (!GDTools.ImageTesting(gdConfig.getmPath())) {
            this.InformCallError(1, "Incorrect picture format!", mGDImageBean);
            return;
        }
        final GDConfig mGDConfig = gdConfig;
        if (null == mGDConfig.getSavePath() || TextUtils.equals((CharSequence)"", (CharSequence)mGDConfig.getSavePath())) {
            mGDConfig.setSavePath(mGDConfig.getmPath());
        }
        mGDImageBean.setmGDConfig(mGDConfig);
        final GDImageBean gdImageBean = mGDImageBean;
        ThreadManager.getIO1().execute(new Runnable(){

            @Override
            public void run() {
                if (mGDConfig.isChangeWH()) {
                    if (mGDConfig.getWidth() <= 0 || mGDConfig.getHeight() <= 0) {
                        try {
                            GDCompressA.this.bitmapMin = new GDCompressUtil().SysCompressMin(mGDConfig.getmPath());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (null == GDCompressA.this.bitmapMin) {
                            GDCompressA.this.InformCallError(0, "Image compression failure!", gdImageBean);
                        } else if (new GDCompressUtil().compressLibJpeg(GDCompressA.this.bitmapMin, mGDConfig.getSavePath())) {
                            GDCompressA.this.InformCallSuccess(mGDConfig.getSavePath(), gdImageBean);
                        } else {
                            GDCompressA.this.InformCallError(0, "Image compression failure!", gdImageBean);
                        }
                    } else {
                        try {
                            GDCompressA.this.bitmapMin = new GDCompressUtil().SysCompressMySamp(mGDConfig.getmPath(), mGDConfig.getWidth(), mGDConfig.getHeight());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (null == GDCompressA.this.bitmapMin) {
                            GDCompressA.this.InformCallError(0, "Image compression failure!", gdImageBean);
                        } else if (new GDCompressUtil().compressLibJpeg(GDCompressA.this.bitmapMin, mGDConfig.getSavePath())) {
                            GDCompressA.this.InformCallSuccess(mGDConfig.getSavePath(), gdImageBean);
                        } else {
                            GDCompressA.this.InformCallError(0, "Image compression failure!", gdImageBean);
                        }
                    }
                } else {
                    try {
                        GDCompressA.this.bitmapMin = GDBitmapUtil.getBitmap(mGDConfig.getmPath());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        GDCompressA.this.bitmapMin = BitmapFactory.decodeFile((String)mGDConfig.getmPath());
                    }
                    if (null == GDCompressA.this.bitmapMin) {
                        GDCompressA.this.InformCallError(0, "Image compression failure!", gdImageBean);
                    } else if (new GDCompressUtil().compressLibJpeg(GDCompressA.this.bitmapMin, mGDConfig.getSavePath())) {
                        GDCompressA.this.InformCallSuccess(mGDConfig.getSavePath(), gdImageBean);
                    } else {
                        GDCompressA.this.InformCallError(0, "Image compression failure!", gdImageBean);
                    }
                }
            }
        });
    }

    private void InformCallSuccess(String path, GDImageBean mGDImageBean) {
        block7: {
            try {
                GDBitmapUtil.saveBitmapDegree(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (null != this.bitmapMin) {
                    this.bitmapMin.recycle();
                    this.bitmapMin = null;
                    System.gc();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            mGDImageBean.setCode(0);
            try {
                final GDImageBean gDImageBean = mGDImageBean;
                ((Activity)this.mContext).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (null != GDCompressA.this.mGDCompressImageListener) {
                            GDCompressA.this.mGDCompressImageListener.OnSuccess(gDImageBean);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                if (null == this.mGDCompressImageListener) break block7;
                this.mGDCompressImageListener.OnSuccess(mGDImageBean);
            }
        }
    }

    private void InformCallError(int code, String errorMsg, GDImageBean mGDImageBean) {
        block5: {
            try {
                if (null != this.bitmapMin) {
                    this.bitmapMin.recycle();
                    this.bitmapMin = null;
                    System.gc();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            mGDImageBean.setCode(code);
            mGDImageBean.setErrorMsg(errorMsg);
            try {
                final GDImageBean gDImageBean = mGDImageBean;
                ((Activity)this.mContext).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (null != GDCompressA.this.mGDCompressImageListener) {
                            GDCompressA.this.mGDCompressImageListener.OnError(gDImageBean);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                if (null == this.mGDCompressImageListener) break block5;
                this.mGDCompressImageListener.OnError(mGDImageBean);
            }
        }
    }
}

