/*
 * Decompiled with CFR 0.152.
 */
package com.wgd.gdcp.gdcplibrary;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.wgd.gdcp.gdcplibrary.GDBitmapUtil;
import com.wgd.gdcp.gdcplibrary.GDCompressImageListener;
import com.wgd.gdcp.gdcplibrary.GDCompressUtil;
import com.wgd.gdcp.gdcplibrary.GDConfig;
import com.wgd.gdcp.gdcplibrary.GDTools;
import com.wgd.gdcp.gdcplibrary.thread.ThreadManager;
import java.util.ArrayList;
import java.util.List;

public class GDCompressC {
    private Context mContext;
    private GDCompressImageListener mGDCompressImageListener;
    private List<Bitmap> garbage = new ArrayList<Bitmap>();

    public GDCompressC(Context context, GDConfig mGDConfig, GDCompressImageListener mGDCompressImageListener) {
        this.mContext = context;
        this.mGDCompressImageListener = mGDCompressImageListener;
        this.start(mGDConfig);
    }

    public GDCompressC(Context context, GDCompressImageListener mGDCompressImageListener) {
        this.mContext = context;
        this.mGDCompressImageListener = mGDCompressImageListener;
    }

    public void start(GDConfig gdConfig) {
        if (null == gdConfig) {
            gdConfig = new GDConfig();
        }
        if (!GDTools.ImageTesting(gdConfig.getmPath())) {
            this.InformCallError(1, "Incorrect picture format!");
            return;
        }
        if (null == gdConfig.getSavePath() || TextUtils.equals((CharSequence)"", (CharSequence)gdConfig.getSavePath())) {
            gdConfig.setSavePath(gdConfig.getmPath());
        }
        final GDConfig mGDConfig = gdConfig;
        ThreadManager.getIO().execute(new Runnable(){

            @Override
            public void run() {
                Bitmap bitmapMin = null;
                if (mGDConfig.isChangeWH()) {
                    if (mGDConfig.getWidth() <= 0 || mGDConfig.getHeight() <= 0) {
                        try {
                            bitmapMin = new GDCompressUtil().SysCompressMin(mGDConfig.getmPath());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        GDCompressC.this.garbage.add(bitmapMin);
                        if (null == bitmapMin) {
                            GDCompressC.this.InformCallError(0, "Image compression failure!");
                        } else if (new GDCompressUtil().compressLibJpeg(bitmapMin, mGDConfig.getSavePath())) {
                            GDCompressC.this.InformCallSuccess(mGDConfig.getSavePath());
                        } else {
                            GDCompressC.this.InformCallError(0, "Image compression failure!");
                        }
                    } else {
                        try {
                            bitmapMin = new GDCompressUtil().SysCompressMySamp(mGDConfig.getmPath(), mGDConfig.getWidth(), mGDConfig.getHeight());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        GDCompressC.this.garbage.add(bitmapMin);
                        if (null == bitmapMin) {
                            GDCompressC.this.InformCallError(0, "Image compression failure!");
                        } else if (new GDCompressUtil().compressLibJpeg(bitmapMin, mGDConfig.getSavePath())) {
                            GDCompressC.this.InformCallSuccess(mGDConfig.getSavePath());
                        } else {
                            GDCompressC.this.InformCallError(0, "Image compression failure!");
                        }
                    }
                } else {
                    try {
                        bitmapMin = GDBitmapUtil.getBitmap(mGDConfig.getmPath());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        bitmapMin = BitmapFactory.decodeFile((String)mGDConfig.getmPath());
                    }
                    GDCompressC.this.garbage.add(bitmapMin);
                    if (null == bitmapMin) {
                        GDCompressC.this.InformCallError(0, "Image compression failure!");
                    } else if (new GDCompressUtil().compressLibJpeg(bitmapMin, mGDConfig.getSavePath())) {
                        GDCompressC.this.InformCallSuccess(mGDConfig.getSavePath());
                    } else {
                        GDCompressC.this.InformCallError(0, "Image compression failure!");
                    }
                }
            }
        });
    }

    private void InformCallSuccess(final String path) {
        block8: {
            try {
                GDBitmapUtil.saveBitmapDegree(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (null != this.garbage && this.garbage.size() > 0) {
                    for (int i = 0; i < this.garbage.size(); ++i) {
                        Bitmap bitmap = this.garbage.get(i);
                        if (bitmap == null || bitmap.isRecycled()) continue;
                        bitmap.recycle();
                        Object var3_6 = null;
                    }
                    this.garbage.clear();
                    System.gc();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                ((Activity)this.mContext).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (null != GDCompressC.this.mGDCompressImageListener) {
                            GDCompressC.this.mGDCompressImageListener.OnSuccess(path);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                if (null == this.mGDCompressImageListener) break block8;
                this.mGDCompressImageListener.OnSuccess(path);
            }
        }
    }

    private void InformCallError(final int code, final String errorMsg) {
        block6: {
            try {
                if (null != this.garbage && this.garbage.size() > 0) {
                    for (int i = 0; i < this.garbage.size(); ++i) {
                        Bitmap bitmap = this.garbage.get(i);
                        if (bitmap == null || bitmap.isRecycled()) continue;
                        bitmap.recycle();
                        bitmap = null;
                    }
                    this.garbage.clear();
                    System.gc();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                ((Activity)this.mContext).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (null != GDCompressC.this.mGDCompressImageListener) {
                            GDCompressC.this.mGDCompressImageListener.OnError(code, errorMsg);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                if (null == this.mGDCompressImageListener) break block6;
                this.mGDCompressImageListener.OnError(code, errorMsg);
            }
        }
    }
}

