/*
 * Decompiled with CFR 0.152.
 */
package com.wgd.gdcp.gdcplibrary;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.util.Log;
import com.wgd.gdcp.gdcplibrary.GDBitmapUtil;
import com.wgd.gdcp.gdcplibrary.GDCompressA;
import com.wgd.gdcp.gdcplibrary.GDCompressC;
import com.wgd.gdcp.gdcplibrary.GDCompressImageListener;
import com.wgd.gdcp.gdcplibrary.GDCompressImageListenerA;
import com.wgd.gdcp.gdcplibrary.GDCompressImageSListener;
import com.wgd.gdcp.gdcplibrary.GDCompressUtil;
import com.wgd.gdcp.gdcplibrary.GDConfig;
import com.wgd.gdcp.gdcplibrary.GDImageBean;
import com.wgd.gdcp.gdcplibrary.GDTools;
import com.wgd.gdcp.gdcplibrary.thread.ThreadManager;
import java.util.ArrayList;
import java.util.List;

public class GDCompressImageS {
    private Context mContext;
    private GDCompressImageSListener mGDCompressImageSListener;
    private List<GDImageBean> imageBeanList;
    List<GDImageBean> newImageBean = new ArrayList<GDImageBean>();
    private boolean isHaveFail = false;
    private List<Bitmap> garbage = new ArrayList<Bitmap>();

    public GDCompressImageS(Context context, List<GDImageBean> imageBeanList, GDCompressImageSListener GDCompressImageSListener2) {
        this.mContext = context;
        this.mGDCompressImageSListener = GDCompressImageSListener2;
        this.imageBeanList = imageBeanList;
        this.startCompressSA();
    }

    private void startCompressSA() {
        if (null != this.imageBeanList && this.imageBeanList.size() > 0) {
            this.newImageBean.clear();
            this.isHaveFail = false;
            GDCompressA gdCompressA = new GDCompressA(this.mContext, new GDCompressImageListenerA(){

                @Override
                public void OnSuccess(GDImageBean gdImageBean) {
                    Log.i((String)"GDCimage", (String)"OnSuccess: ========0002========");
                    GDCompressImageS.this.InformCallFinish(gdImageBean);
                }

                @Override
                public void OnError(GDImageBean gdImageBean) {
                    Log.i((String)"GDCimage", (String)"OnError: ========0003========");
                    GDCompressImageS.this.InformCallFinish(gdImageBean);
                }
            });
            for (int i = 0; i < this.imageBeanList.size(); ++i) {
                GDImageBean imageBeana = this.imageBeanList.get(i);
                gdCompressA.start(imageBeana);
            }
        } else if (null != this.mGDCompressImageSListener) {
            this.mGDCompressImageSListener.OnError(this.newImageBean);
        }
    }

    private void startCompressS() {
        if (null != this.imageBeanList && this.imageBeanList.size() > 0) {
            this.newImageBean.clear();
            this.isHaveFail = false;
            for (int i = 0; i < this.imageBeanList.size(); ++i) {
                final GDImageBean imageBeana = this.imageBeanList.get(i);
                Log.i((String)"GDCimage", (String)("startCompressS: ========0001========" + i));
                new GDCompressC(this.mContext, imageBeana.getmGDConfig(), new GDCompressImageListener(){

                    @Override
                    public void OnSuccess(String path) {
                        Log.i((String)"GDCimage", (String)"OnSuccess: ========0002========");
                        GDImageBean imageBean = imageBeana;
                        imageBean.setCode(0);
                        GDCompressImageS.this.InformCallFinish(imageBean);
                    }

                    @Override
                    public void OnError(int code, String errorMsg) {
                        Log.i((String)"GDCimage", (String)"OnError: ========0003========");
                        GDImageBean imageBean = imageBeana;
                        GDCompressImageS.this.isHaveFail = true;
                        imageBean.setCode(1);
                        imageBean.setErrorMsg("Image compression failure!");
                        GDCompressImageS.this.InformCallFinish(imageBean);
                    }
                });
            }
        } else if (null != this.mGDCompressImageSListener) {
            this.mGDCompressImageSListener.OnError(this.newImageBean);
        }
    }

    private void startCompress() {
        Log.i((String)"GDCimage", (String)("startCompress: ======imageBeanList.size()=======" + this.imageBeanList.size()));
        if (null != this.imageBeanList && this.imageBeanList.size() > 0) {
            this.newImageBean.clear();
            this.isHaveFail = false;
            for (int i = 0; i < this.imageBeanList.size(); ++i) {
                final GDImageBean imageBeana = this.imageBeanList.get(i);
                ThreadManager.getIO().execute(new Runnable(){

                    @Override
                    public void run() {
                        Bitmap bitmapMin = null;
                        String mPath = imageBeana.getmGDConfig().getmPath();
                        GDImageBean imageBean = imageBeana;
                        if (!GDTools.ImageTesting(mPath)) {
                            imageBean.setCode(1);
                            imageBean.setErrorMsg("Image compression failure!");
                            GDCompressImageS.this.InformCallFinish(imageBean);
                        } else {
                            GDConfig mGDConfig;
                            String savePath = imageBeana.getmGDConfig().getSavePath();
                            if (null == savePath || TextUtils.isEmpty((CharSequence)savePath)) {
                                GDConfig gdConfig = imageBeana.getmGDConfig();
                                gdConfig.setSavePath(mPath);
                                imageBean.setmGDConfig(gdConfig);
                            }
                            if ((mGDConfig = imageBean.getmGDConfig()).isChangeWH()) {
                                if (mGDConfig.getWidth() <= 0 || mGDConfig.getHeight() <= 0) {
                                    try {
                                        bitmapMin = new GDCompressUtil().SysCompressMin(mGDConfig.getmPath());
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    if (null == bitmapMin) {
                                        Log.i((String)"GDCimage", (String)"startCompress: ====== null==bitmapMin =======");
                                    }
                                    GDCompressImageS.this.garbage.add(bitmapMin);
                                    if (null == bitmapMin) {
                                        GDCompressImageS.this.isHaveFail = true;
                                        imageBean.setCode(1);
                                        imageBean.setErrorMsg("Image compression failure!");
                                    } else if (new GDCompressUtil().compressLibJpeg(bitmapMin, mGDConfig.getSavePath())) {
                                        imageBean.setCode(0);
                                    } else {
                                        GDCompressImageS.this.isHaveFail = true;
                                        imageBean.setCode(1);
                                        imageBean.setErrorMsg("Image compression failure!");
                                    }
                                    GDCompressImageS.this.InformCallFinish(imageBean);
                                } else {
                                    try {
                                        bitmapMin = new GDCompressUtil().SysCompressMin(mGDConfig.getmPath());
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    GDCompressImageS.this.garbage.add(bitmapMin);
                                    if (null == bitmapMin) {
                                        GDCompressImageS.this.isHaveFail = true;
                                        imageBean.setCode(1);
                                        imageBean.setErrorMsg("Image compression failure!");
                                    } else if (new GDCompressUtil().compressLibJpeg(bitmapMin, mGDConfig.getSavePath())) {
                                        imageBean.setCode(0);
                                    } else {
                                        GDCompressImageS.this.isHaveFail = true;
                                        imageBean.setCode(1);
                                        imageBean.setErrorMsg("Image compression failure!");
                                    }
                                    GDCompressImageS.this.InformCallFinish(imageBean);
                                }
                            } else {
                                try {
                                    bitmapMin = GDBitmapUtil.getBitmap(mGDConfig.getmPath());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    bitmapMin = BitmapFactory.decodeFile((String)mGDConfig.getmPath());
                                }
                                if (null == bitmapMin) {
                                    Log.i((String)"GDCimage", (String)"startCompress: ====  else  == null==bitmapMin =======");
                                }
                                GDCompressImageS.this.garbage.add(bitmapMin);
                                if (new GDCompressUtil().compressLibJpeg(bitmapMin, mGDConfig.getSavePath())) {
                                    imageBean.setCode(0);
                                } else {
                                    GDCompressImageS.this.isHaveFail = true;
                                    imageBean.setCode(1);
                                    imageBean.setErrorMsg("Image compression failure!");
                                }
                                GDCompressImageS.this.InformCallFinish(imageBean);
                            }
                        }
                    }
                });
            }
        } else if (null != this.mGDCompressImageSListener) {
            this.mGDCompressImageSListener.OnError(this.newImageBean);
        }
    }

    private void InformCallFinish(GDImageBean imageBean) {
        block10: {
            this.newImageBean.add(imageBean);
            try {
                GDBitmapUtil.saveBitmapDegree(imageBean.getmGDConfig().getSavePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.newImageBean.size() >= this.imageBeanList.size()) {
                try {
                    if (null != this.garbage && this.garbage.size() > 0) {
                        for (int i = 0; i < this.garbage.size(); ++i) {
                            Bitmap bitmap = this.garbage.get(i);
                            if (bitmap == null || bitmap.isRecycled()) continue;
                            bitmap.recycle();
                            Object var3_6 = null;
                        }
                        System.gc();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    ((Activity)this.mContext).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (null != GDCompressImageS.this.mGDCompressImageSListener) {
                                if (GDCompressImageS.this.isHaveFail) {
                                    GDCompressImageS.this.mGDCompressImageSListener.OnError(GDCompressImageS.this.newImageBean);
                                } else {
                                    GDCompressImageS.this.mGDCompressImageSListener.OnSuccess(GDCompressImageS.this.newImageBean);
                                }
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (null == this.mGDCompressImageSListener) break block10;
                    if (this.isHaveFail) {
                        this.mGDCompressImageSListener.OnError(this.newImageBean);
                    }
                    this.mGDCompressImageSListener.OnSuccess(this.newImageBean);
                }
            }
        }
    }
}

