/*
 * Decompiled with CFR 0.152.
 */
package com.wgd.gdcp.gdcplibrary;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.wgd.gdcp.gdcplibrary.GDTools;
import com.wgd.gdcp.gdcplibrary.ImageUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class GDCompressUtil {
    private int computeSize(int srcWidth, int srcHeight) {
        srcWidth = srcWidth % 2 == 1 ? srcWidth + 1 : srcWidth;
        srcHeight = srcHeight % 2 == 1 ? srcHeight + 1 : srcHeight;
        int longSide = Math.max(srcWidth, srcHeight);
        int shortSide = Math.min(srcWidth, srcHeight);
        float scale = (float)shortSide / (float)longSide;
        if (scale <= 1.0f && (double)scale > 0.5625) {
            if (longSide < 1664) {
                return 1;
            }
            if (longSide >= 1664 && longSide < 4990) {
                return 2;
            }
            if (longSide > 4990 && longSide < 10240) {
                return 4;
            }
            return longSide / 1280 == 0 ? 1 : longSide / 1280;
        }
        if ((double)scale <= 0.5625 && (double)scale > 0.5) {
            return longSide / 1280 == 0 ? 1 : longSide / 1280;
        }
        return (int)Math.ceil((double)longSide / (1280.0 / (double)scale));
    }

    public Bitmap SysCompressMin(String imgFilePath) throws Exception {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        FileInputStream inputStream = null;
        int imgWidth = 0;
        int imgHeight = 0;
        try {
            inputStream = new FileInputStream(imgFilePath);
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            imgWidth = options.outWidth;
            imgHeight = options.outHeight;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        options.inJustDecodeBounds = false;
        options.inSampleSize = this.computeSize(imgWidth, imgHeight);
        try {
            inputStream = new FileInputStream(imgFilePath);
            return BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Bitmap SysCompressMin(Bitmap bitmap) throws Exception {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = this.computeSize(bitmap.getWidth(), bitmap.getHeight());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)stream);
        byte[] byteArray = stream.toByteArray();
        bitmap = BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)options);
        return bitmap;
    }

    public Bitmap SysCompressMySamp(String imgFilePath, int width, int height) throws Exception {
        int samp;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        FileInputStream inputStream = null;
        int imgWidth = 0;
        int imgHeight = 0;
        try {
            inputStream = new FileInputStream(imgFilePath);
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            imgWidth = options.outWidth;
            imgHeight = options.outHeight;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        options.inJustDecodeBounds = false;
        options.inSampleSize = samp = GDTools.getSampWHforImage(imgWidth, imgHeight, width, height);
        try {
            inputStream = new FileInputStream(imgFilePath);
            return BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean compressLibJpeg(Bitmap bitmap, String savePath) {
        try {
            if (null == bitmap) {
                return false;
            }
            return this.compressLibJpeg(bitmap, savePath, 20);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean compressLibJpeg(Bitmap bitmap, String savePath, int quality) {
        try {
            if (null == bitmap) {
                return false;
            }
            boolean codeString = ImageUtils.compressBitmap(bitmap, bitmap.getWidth(), bitmap.getHeight(), savePath, quality);
            return codeString;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean compressLibJpeg(String path, String savePath) {
        try {
            Bitmap bitmap = BitmapFactory.decodeFile((String)path);
            return this.compressLibJpeg(bitmap, savePath, 20);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean compressLibJpeg(String path, String savePath, int quality) {
        try {
            Bitmap bitmap = BitmapFactory.decodeFile((String)path);
            return this.compressLibJpeg(bitmap, savePath, quality);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

