/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.agreement.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;

public class SystemConfig {
    private PropertiesConfiguration system;

    private SystemConfig() {
        this.init();
    }

    private void init() {
        String systemProperties = System.getProperty("system.properties");
        this.system = new PropertiesConfiguration();
        this.system.setEncoding("UTF-8");
        this.system.setDelimiterParsingDisabled(true);
        try {
            this.system.load(new File(systemProperties));
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        this.system.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
    }

    public static SystemConfig getInstance() {
        return SystemProperties.INSTANCE.getInstance();
    }

    public String getString(String key) {
        return this.system.getString(key);
    }

    public String getString(String key, String defaultValue) {
        return this.system.getString(key, defaultValue);
    }

    public int getInt(String key) {
        return this.system.getInt(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.system.getInt(key, defaultValue);
    }

    public long getLong(String key) {
        return this.system.getLong(key);
    }

    public long getLong(String key, long defaultValue) {
        return this.system.getLong(key, defaultValue);
    }

    public boolean getBoolean(String key) {
        return this.system.getBoolean(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.system.getBoolean(key, defaultValue);
    }

    public void batchUpdateValue(Map<String, String> propertiesMap) {
        for (Map.Entry<String, String> propertyEntry : propertiesMap.entrySet()) {
            this.updateValueByKey(propertyEntry.getKey(), propertyEntry.getValue());
        }
    }

    public void updateValueByKey(String key, String value) {
        try {
            this.system.setProperty(key, (Object)value);
            this.system.save(System.getProperty("system.properties"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("update properties fail.key:%s, %s:value.", key, value) + e.getMessage(), e);
        }
    }

    public String[] getPropertyNoteByKey(String key) {
        String value = this.system.getString(key);
        String propertyLine = key + "=" + value;
        String note = this.findNote(propertyLine);
        return new String[]{key, value, note};
    }

    public List<String[]> getPropertyNoteListByPrefix(String prefix) {
        ArrayList<String[]> results = new ArrayList<String[]>();
        Iterator keyIterator = this.system.getKeys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            if (!key.startsWith(prefix)) continue;
            String value = this.system.getString(key);
            String propertyLine = key + "=" + value;
            results.add(new String[]{key, value, this.findNote(propertyLine)});
        }
        return results;
    }

    public List<String[]> getAllPropertyNoteList() {
        ArrayList<String[]> results = new ArrayList<String[]>();
        Iterator keyIterator = this.system.getKeys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            String value = this.system.getString(key);
            String propertyLine = key + "=" + value;
            results.add(new String[]{key, value, this.findNote(propertyLine)});
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findNote(String propertyLine) {
        Scanner scanner;
        String systemPropertiesPath = System.getProperty("system.properties");
        try {
            scanner = new Scanner(new FileInputStream(systemPropertiesPath));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("classpath:system.properties can't find" + e.getMessage(), e);
        }
        String lastLine = null;
        try {
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().replaceAll("\\s*", "");
                if (propertyLine.equals(line)) {
                    if (lastLine != null && lastLine.length() > 0 && lastLine.charAt(0) == '#') {
                        String string = lastLine.substring(1);
                        return string;
                    }
                    String string = null;
                    return string;
                }
                lastLine = line;
            }
        }
        finally {
            scanner.close();
        }
        return null;
    }

    public FileConfiguration getSystem() {
        return this.system;
    }

    private static enum SystemProperties {
        INSTANCE;

        private SystemConfig config = new SystemConfig();

        public SystemConfig getInstance() {
            return this.config;
        }
    }
}

