/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.agreement.listener;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.File;
import java.text.MessageFormat;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.LoggerFactory;

@WebListener
public class ConfigurationSettingListener
implements ServletContextListener {
    private static final String CONFIG_LOAD_PATH = "/app.properties";

    private static boolean setLogCfg(String path) {
        File file = new File(path);
        if (!file.exists()) {
            System.out.println("\u65e5\u5fd7\u914d\u7f6e\u6587\u4ef6[ " + path + "]\u8bfb\u53d6\u5931\u8d25");
            return false;
        }
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext((Context)lc);
        lc.reset();
        try {
            joranConfigurator.doConfigure(file);
        }
        catch (JoranException e) {
            System.out.println("\u65e5\u5fd7\u914d\u7f6e\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void contextInitialized(ServletContextEvent sce) {
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    static {
        System.out.println("----------------------------------");
        PropertiesConfiguration instance = new PropertiesConfiguration();
        instance.setEncoding("UTF-8");
        instance.setURL(ConfigurationSettingListener.class.getResource(CONFIG_LOAD_PATH));
        try {
            instance.load();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        boolean ifWindows = !"/".equals(System.getProperty("file.separator"));
        String projectName = instance.getString("project.name");
        System.setProperty("project.name", projectName);
        System.out.println("-------------------------------\u7cfb\u7edf[" + System.getProperty("project.name") + "]\u521d\u59cb\u5316-------------------------------");
        String datasource = instance.getString(ifWindows ? "windows.datasource.properties" : "linux.datasource.properties");
        System.setProperty("datasource.properties", MessageFormat.format(datasource, projectName));
        System.out.println(" \u52a0\u8f7d\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6[" + System.getProperty("datasource.properties") + "]");
        String system = instance.getString(ifWindows ? "windows.system.properties" : "linux.system.properties");
        System.setProperty("system.properties", MessageFormat.format(system, projectName));
        System.out.println(" \u52a0\u8f7d\u7cfb\u7edf\u914d\u7f6e\u4fe1\u606f[" + System.getProperty("system.properties") + "]");
        String logfile = instance.getString(ifWindows ? "windows.logfile.path" : "linux.logfile.path");
        System.setProperty("logfile.path", MessageFormat.format(logfile, projectName));
        System.out.println(" \u8bbe\u7f6e\u65e5\u5fd7\u6587\u4ef6\u5b58\u50a8\u8def\u5f84[" + System.getProperty("logfile.path") + "]");
        String logback = instance.getString(ifWindows ? "windows.logback.xml" : "linux.logback.xml");
        String logbackXML = MessageFormat.format(logback, projectName);
        System.setProperty("logback.xml", logbackXML);
        System.out.println(" \u52a0\u8f7dlogback.xml\u6587\u4ef6[" + System.getProperty("logback.xml") + "]");
        ConfigurationSettingListener.setLogCfg(logbackXML);
        System.out.println("---------------------------------------------------------------------------");
    }
}

