/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.a3rdplugin.demo.ocr;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import com.aircert.BusProvider;
import com.aircert.util.ModuleLog;
import com.xdja.a3rdplugin.demo.event.OCREvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class XDJAOCR
extends OCREvent {
    public static final int HEAD = 2;
    public static final int TAIL = 3;
    public static final Float MIN_VERSION = Float.valueOf(5.3f);
    public static final String APK_NAME = "ocr_shibieku.apk";
    public static final String APK_PATH = Environment.getExternalStorageDirectory().getPath() + File.separator + "ocr_shibieku.apk";
    public static final String APK_PACKAGE_NAME = "com.xdja.zdsb";
    public static final String ACTION = "com.xdja.zdsb.newsfzsb.action";
    public static final String PARAM_PACKAGE_NAME = "packagename";
    public static final String PARAM_ID_CARD = "sfzbs";

    public static boolean isInstall(Context context) {
        return XDJAOCR.isApplicationInstalled(context, APK_PACKAGE_NAME);
    }

    public static boolean isVersionOK(Context context) {
        String version = XDJAOCR.getVersion(context, APK_PACKAGE_NAME);
        ModuleLog.d((Object)("\u5f53\u524dXDJA OCR\u7684\u7248\u672c:" + version));
        if (TextUtils.isEmpty((CharSequence)version)) {
            return false;
        }
        try {
            Float versionCode = Float.valueOf(Float.parseFloat(version));
            return versionCode.floatValue() >= MIN_VERSION.floatValue();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getVersion(Context context, String packageName) {
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(packageName, 0);
            return info.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void copyFile(final Context context) {
        AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    XDJAOCR.assetsDataToDest(context, XDJAOCR.APK_NAME, APK_PATH);
                }
                catch (IOException ex) {
                    ModuleLog.e((Object)("copy xdja ocr apk IOException:" + ex.getMessage()));
                }
                catch (RuntimeException e) {
                    ModuleLog.e((Object)("copy xdja ocr apk Runtime Exception" + e.getMessage()));
                }
                catch (Exception e) {
                    ModuleLog.e((Object)("copy xdja ocr apk other Exception" + e.getMessage()));
                }
            }
        });
    }

    public static void copyFileTellMe(final Context context) {
        AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    XDJAOCR.assetsDataToDest(context, XDJAOCR.APK_NAME, APK_PATH);
                }
                catch (IOException ex) {
                    ModuleLog.e((Object)("copy xdja ocr apk IOException:" + ex.getMessage()));
                }
                catch (RuntimeException e) {
                    ModuleLog.e((Object)("copy xdja ocr apk Runtime Exception" + e.getMessage()));
                }
                catch (Exception e) {
                    ModuleLog.e((Object)("copy xdja ocr apk other Exception" + e.getMessage()));
                }
                finally {
                    BusProvider.getMainProvider().post((Object)new XDJAOCR());
                }
            }
        });
    }

    public static boolean apkFileExist() {
        return new File(APK_PATH).exists();
    }

    public static void install(Context context, boolean isAAR) {
        File file = new File(APK_PATH);
        if (file.exists()) {
            Intent intent = new Intent("android.intent.action.VIEW");
            if (Build.VERSION.SDK_INT >= 24) {
                intent.addFlags(1);
                String auth = !isAAR ? "com.xdja.aircert.standalone.fileprovider" : "com.xdja.aircert.fileprovider";
                Uri uri = FileProvider.getUriForFile((Context)context, (String)auth, (File)file);
                intent.setDataAndType(uri, "application/vnd.android.package-archive");
            } else {
                intent.setDataAndType(Uri.fromFile((File)file), "application/vnd.android.package-archive");
            }
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    private static void assetsDataToDest(Context context, String origin, String destination) throws IOException {
        InputStream input = context.getAssets().open(origin);
        try (FileOutputStream output = new FileOutputStream(destination);){
            byte[] buffer = new byte[1024];
            int length = input.read(buffer);
            while (length > 0) {
                ((OutputStream)output).write(buffer, 0, length);
                length = input.read(buffer);
            }
            output.flush();
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isApplicationInstalled(Context context, String appPackageName) {
        PackageManager packageManager = context.getPackageManager();
        List info = packageManager.getInstalledPackages(0);
        if (info != null) {
            for (int i = 0; i < info.size(); ++i) {
                String pn = ((PackageInfo)info.get((int)i)).packageName;
                if (!appPackageName.equals(pn)) continue;
                return true;
            }
        }
        return false;
    }

    public static String formatValidDate(String validDate) {
        String[] array = validDate.split("-");
        String former = array[0];
        String later = array[1];
        StringBuilder sb = new StringBuilder();
        sb.append(former.substring(0, 4));
        sb.append(".");
        sb.append(former.substring(4, 6));
        sb.append(".");
        sb.append(former.substring(6, 8));
        sb.append("-");
        sb.append(later.substring(0, 4));
        sb.append(".");
        sb.append(later.substring(4, 6));
        sb.append(".");
        sb.append(later.substring(6, 8));
        return sb.toString();
    }
}

