package com.xdja.a3rdplugin.demo;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Environment;

import com.aircert.util.ModuleLog;
import com.xdja.a3rdplugin.demo.activity.ANRONGOCRActivity;
import com.xdja.a3rdplugin.demo.activity.XDJAOCRActivity;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * OCR识别厂商<br>
 * 默认云从
 * Created by zjc on 2018/7/5 0005.
 */

public class OCRCompany {

    /**
     * 这个POSITION是为了区分不同第三方服务出现的厂家同名状况
     */
    public static final int POSITION = 222;

    /**
     * 公司 - 李伟军提供
     */
    public static final String XDJA = "信大捷安";

    /**
     * 云从
     */
    public static final String YUNCONG = "云从";

    /**
     * 安荣
     */
    public static final String ANRONG = "安荣";

    /**
     * 百度
     */
    public static final String BAIDU = "百度";

    private static final List<ConfigBean> list = new ArrayList<>();

    public static List<ConfigBean> getList() {
        return list;
    }

    static {
        list.add(new ConfigBean(XDJA));
        list.add(new ConfigBean(YUNCONG));
        list.add(new ConfigBean(ANRONG));
    }


    /**
     * 信大捷安OCR
     *
     * @param context
     */
    public static void XDJA(Context context, int side) {
        Intent intent = new Intent(context, XDJAOCRActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.putExtra("side", side);
        context.startActivity(intent);
    }

    /**
     * 正面
     */
    public static final int HEAD = 1;

    /**
     * 反面
     */
    public static final int TAIL = 2;

    /**
     * 安荣
     *
     * @param context
     * @param side    正面还是反面，正面是1，反面是2
     */
    public static void ANRONG(Context context, int side) {
        Intent intent = new Intent(context, ANRONGOCRActivity.class);
        intent.putExtra("recogType", side); // 参数1为正面 2为反面
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }


}
