package com.xdja.a3rdplugin.demo.activity;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;

import com.aircert.BusProvider;
import com.aircert.util.ModuleLog;
import com.alibaba.fastjson.JSON;
import com.xdja.a3rdplugin.R;
import com.xdja.a3rdplugin.demo.ModuleToast;
import com.xdja.a3rdplugin.demo.event.IDCardHeadResult;
import com.xdja.a3rdplugin.demo.event.XDJAIDTailResult;

import static com.xdja.a3rdplugin.demo.OCRCompany.XDJA;

/**
 * 调用信大捷安OCR的中间界面
 */
public class XDJAOCRActivity extends AppCompatActivity {

    public static final int XDJA = 0;

    private int side;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        side = getIntent().getIntExtra("side", 0);

        XDJAOCR();


    }

    @Override
    protected void onResume() {
        super.onResume();

    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);

        side = intent.getIntExtra("side", 0);

        XDJAOCR();

    }

    private void XDJAOCR() {

        try {

//            Intent intent = new Intent("com.xdja.zdsb.sfzsb.action");
//            intent.putExtra("packagename", getPackageName());
//            intent.putExtra("sfzbs", side);
//            startActivityForResult(intent, XDJA);

            Intent intent = new Intent("com.xdja.zdsb.sfzsb.action");
            intent.putExtra("nMainId", side); // nMainId,传入3标识识别身份证反面，不传或者传2标识识别正面
            startActivityForResult(intent, XDJA);


        } catch (Exception e) {
            ModuleToast.show(this, R.string.not_install_xdja_ocr);
        }

        // TODO: 2018/7/2 0002  能不能检测授权，授权获取相机拍摄权限


    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if (resultCode == RESULT_OK) {
            if (requestCode == XDJA) {
                //获取身份证号
                //String sfzh = data.getStringExtra("sfzh");
                String json = data.getStringExtra("json");//json字符串，所有信息

                if (json.contains("blzd")) {
                    IDCardHeadResult result = JSON.parseObject(json, IDCardHeadResult.class);
                    BusProvider.getMainProvider().post(result);
                } else if (json.contains("qfjg")) {
                    XDJAIDTailResult result = JSON.parseObject(json, XDJAIDTailResult.class);
                    BusProvider.getMainProvider().post(result);
                }

                finish();
            }
        }


    }

}
