package com.xdja.a3rdplugin.demo.event;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * 正面的身份证信息
 * 安荣和信大捷安OCR共用<br>
 * 因为解析信大捷安OCR的身份证信息时会直接调用JSON.parseObject<br>
 * 所以字段与JSON中的保持一致，为中文的简写<br>
 * <font color="red">正常的代码禁止写中文</font>
 */
public class IDCardHeadResult implements Parcelable {

    /**
     * 保留字段
     */
    private String blzd = "";
    /**
     * 住址
     */
    private String csdz = "";
    /**
     * 出生日期
     */
    private String csrq = "";
    /**
     * 民族
     */
    private String mz = "";
    /**
     * 身份证号
     */
    private String sfzh = "";
    /**
     * 性别
     */
    private String xb = "";
    /**
     * 姓名
     */
    private String xm = "";

    public IDCardHeadResult(Parcel in) {
        blzd = in.readString();
        csdz = in.readString();
        csrq = in.readString();
        mz = in.readString();
        sfzh = in.readString();
        xb = in.readString();
        xm = in.readString();
    }

    public IDCardHeadResult() {

    }


    public static final Creator<IDCardHeadResult> CREATOR = new Creator<IDCardHeadResult>() {
        @Override
        public IDCardHeadResult createFromParcel(Parcel in) {
            return new IDCardHeadResult(in);
        }

        @Override
        public IDCardHeadResult[] newArray(int size) {
            return new IDCardHeadResult[size];
        }
    };

    public void setBlzd(String blzd) {
        this.blzd = blzd;
    }

    public String getBlzd() {
        return blzd;
    }

    public void setCsdz(String csdz) {
        this.csdz = csdz;
    }

    public String getCsdz() {
        return csdz;
    }

    public String getCsrq() {
        return csrq;
    }

    public void setCsrq(String csrq) {
        this.csrq = csrq;
    }

    public void setMz(String mz) {
        this.mz = mz;
    }

    public String getMz() {
        return mz;
    }

    public void setSfzh(String sfzh) {
        this.sfzh = sfzh;
    }

    public String getSfzh() {
        return sfzh;
    }

    public void setXb(String xb) {
        this.xb = xb;
    }

    public String getXb() {
        return xb;
    }

    public void setXm(String xm) {
        this.xm = xm;
    }

    public String getXm() {
        return xm;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(blzd);
        parcel.writeString(csdz);
        parcel.writeString(csrq);
        parcel.writeString(mz);
        parcel.writeString(sfzh);
        parcel.writeString(xb);
        parcel.writeString(xm);
    }

    @Override
    public String toString() {
        return "IDCardHeadResult{" +
                "blzd='" + blzd + '\'' +
                ", csdz='" + csdz + '\'' +
                ", csrq='" + csrq + '\'' +
                ", mz='" + mz + '\'' +
                ", sfzh='" + sfzh + '\'' +
                ", xb='" + xb + '\'' +
                ", xm='" + xm + '\'' +
                '}';
    }
}