package com.xdja.a3rdplugin.demo.ocr;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;

import com.aircert.BusProvider;
import com.aircert.util.ModuleLog;
import com.xdja.a3rdplugin.demo.event.OCREvent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

/**
 * Created by Administrator on 2019/10/23 0023.
 */

public class XDJAOCR extends OCREvent {

    public static final int HEAD = 2;

    public static final int TAIL = 3;

    public static final Float MIN_VERSION = 5.3f;

    /**
     * assets目录下APK的名称
     */
    public static final String APK_NAME = "ocr_shibieku.apk";

    /**
     * 将信大捷安OCR的安装包复制到手机上的目录
     */
    public static final String APK_PATH =
            Environment.getExternalStorageDirectory().getPath()
                    + File.separator
                    + APK_NAME;

    /**
     * 信大捷安OCR APK包名
     */
    public static final String APK_PACKAGE_NAME = "com.xdja.zdsb";

    /**
     * 信大捷安OCR 定制版 调用Action
     */
    public static final String ACTION = "com.xdja.zdsb.newsfzsb.action";

    /**
     * 参数 包名
     */
    public static final String PARAM_PACKAGE_NAME = "packagename";

    /**
     * 参数 身份证
     */
    public static final String PARAM_ID_CARD = "sfzbs";

    /**
     * 信大捷安OCR APK是否已安装
     *
     * @param context
     * @return
     */
    public static boolean isInstall(Context context) {

        return isApplicationInstalled(context, APK_PACKAGE_NAME);

    }

    /**
     * 信大捷安APK 版本是否符合要求
     *
     * @param context
     * @return
     */
    public static boolean isVersionOK(Context context) {

        String version = getVersion(context, APK_PACKAGE_NAME);

        ModuleLog.d("当前XDJA OCR的版本:" + version);

        if (TextUtils.isEmpty(version)) {
            // 为""代表版本号转换出错
            return false;
        }

        try {
            Float versionCode = Float.parseFloat(version);
            return versionCode >= MIN_VERSION;
        } catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }

    }

    /**
     * 根据包名获取应用版本
     *
     * @param context
     * @param packageName
     * @return
     */
    public static String getVersion(Context context, String packageName) {
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(packageName, 0);
//            ModuleToast.show(this, info.versionName + ":" + info.version);
            return info.versionName;
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    /**
     * 复制asset目录下的信大捷安OCR APK文件到目录下
     *
     * @param context
     */
    public static void copyFile(final Context context) {

        AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable() {
            @Override
            public void run() {

                try {
                    assetsDataToDest(context, APK_NAME,
                            APK_PATH);

                } catch (IOException ex) {
                    ModuleLog.e("copy xdja ocr apk IOException:" + ex.getMessage());
                } catch (RuntimeException e) {
                    ModuleLog.e("copy xdja ocr apk Runtime Exception" + e.getMessage());
                } catch (Exception e) {
                    ModuleLog.e("copy xdja ocr apk other Exception" + e.getMessage());
                } finally {
                }

            }

        });

    }

    /**
     * 复制asset目录下的信大捷安OCR APK文件到目录下
     * 完成后进行事件通知
     *
     * @param context
     */
    public static void copyFileTellMe(final Context context) {
        AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable() {
            @Override
            public void run() {

                try {
                    assetsDataToDest(context, APK_NAME,
                            APK_PATH);

                } catch (IOException ex) {
                    ModuleLog.e("copy xdja ocr apk IOException:" + ex.getMessage());
                } catch (RuntimeException e) {
                    ModuleLog.e("copy xdja ocr apk Runtime Exception" + e.getMessage());
                } catch (Exception e) {
                    ModuleLog.e("copy xdja ocr apk other Exception" + e.getMessage());
                } finally {
                    BusProvider.getMainProvider().post(new XDJAOCR());
                }

            }

        });
    }

    /**
     * 存储目录下识别库的APK文件是否存在
     *
     * @return
     */
    public static boolean apkFileExist() {
        return new File(APK_PATH).exists();
    }

    /**
     * 安装apk
     */
    public static void install(Context context, boolean isAAR) {
        File file = new File(APK_PATH);
        if (file.exists()) {
            Intent intent = new Intent(Intent.ACTION_VIEW);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                intent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
                String auth = !isAAR ? "com.xdja.aircert.standalone.fileprovider" : "com.xdja.aircert.fileprovider";
                Uri uri = FileProvider.getUriForFile(context, auth, file);
                intent.setDataAndType(uri, "application/vnd.android.package-archive");
            } else {
                intent.setDataAndType(Uri.fromFile(file), "application/vnd.android.package-archive");
            }
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
        }
    }


    /**
     * 拷贝assets下文件
     *
     * @param context
     * @param origin
     * @param destination
     * @throws IOException
     */
    private static void assetsDataToDest(Context context, String origin, String destination) throws IOException {
        InputStream input = context.getAssets().open(origin);
        try(OutputStream output = new FileOutputStream(destination)){
            byte[] buffer = new byte[1024];
            int length = input.read(buffer);
            while (length > 0) {
                output.write(buffer, 0, length);
                length = input.read(buffer);
            }
            output.flush();
            input.close();
        }catch (Exception e){
            e.printStackTrace();
        }

    }

    /**
     * 根据包名判断手机是否安装某个应用
     *
     * @param context        context
     * @param appPackageName 应用包名
     * @return true：安装，false：未安装
     */
    private static boolean isApplicationInstalled(Context context, String appPackageName) {
        PackageManager packageManager = context.getPackageManager();// 获取packagemanager
        List<PackageInfo> info = packageManager.getInstalledPackages(0);// 获取所有已安装程序的包信息
        if (info != null) {
            for (int i = 0; i < info.size(); i++) {
                String pn = info.get(i).packageName;
                if (appPackageName.equals(pn)) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 转换身份证有效日期的格式<br><br>
     *
     * @param validDate 身份证有效期,格式20101126-20201126
     * @return 转换后的格式“2009.09.04-2019.09.04”
     */
    public static String formatValidDate(String validDate) {
        String array[] = validDate.split("-");
        // 将“-”前后的两个日期分开
        String former = array[0];
        String later = array[1];

        StringBuilder sb = new StringBuilder();
        sb.append(former.substring(0, 4));
        sb.append(".");
        sb.append(former.substring(4, 6));
        sb.append(".");
        sb.append(former.substring(6, 8));

        sb.append("-");

        sb.append(later.substring(0, 4));
        sb.append(".");
        sb.append(later.substring(4, 6));
        sb.append(".");
        sb.append(later.substring(6, 8));

        return sb.toString();
    }

}
