package com.xdja.aircert.sdk.config;

import android.text.TextUtils;

/**
 * @author: lyl
 * desc:  sdk 配置类
 * 2020/11/2
 */
public final class AirCertConfig {
    /**
     * 服务地址
     */
    private String serverAddress;
    /**
     * vhsm地址
     */
    private String vhsmAddress;
    /**
     * 容器号
     */
    private int containerNum;
    /**
     * 卡类型
     */
    @AirCertConstant.DEV_TYPE
    private int certType;
    /**
     * 加密类型
     */
    @AirCertConstant.CERT_TYPE
    private int algType;

    private AirCertConfig(Builder builder) {
        this.serverAddress = builder.serverAddress;
        this.vhsmAddress = builder.vhsmAddress;
        this.containerNum = builder.containerNum;
        this.certType = builder.certType == 0 ? AirCertConstant.CERT_TYPE_SM2_DOUBLE : builder.certType;
        this.algType = builder.algType == 0 ? AirCertConstant.DEV_TYPE_VHSM : builder.algType;
    }

    public String getServerAddress() {
        return serverAddress;
    }

    public String getVhsmAddress() {
        return vhsmAddress;
    }

    public int getContainerNum() {
        return containerNum;
    }

    public int getCertType() {
        return certType;
    }

    public int getAlgType() {
        return algType;
    }

    public static class Builder {
        private String serverAddress;
        private String vhsmAddress;
        private int containerNum;
        @AirCertConstant.DEV_TYPE
        private int certType;
        @AirCertConstant.CERT_TYPE
        private int algType;

        public Builder setServerAddress(String serverAddress) {
            if (TextUtils.isEmpty(serverAddress)) {
                throw new IllegalStateException("serverAddress == null");
            }
            this.serverAddress = serverAddress;
            return this;
        }

        public Builder setVhsmAddress(String vhsmAddress) {
            if (TextUtils.isEmpty(vhsmAddress)) {
                throw new IllegalStateException("vhsmAddress == null");
            }
            this.vhsmAddress = vhsmAddress;
            return this;
        }

        public Builder setContainerNum(int containerNum) {
            this.containerNum = containerNum;
            return this;
        }

        public Builder setCertType(@AirCertConstant.DEV_TYPE int certType) {
            this.certType = certType;
            return this;
        }

        public Builder setAlgType(@AirCertConstant.CERT_TYPE int algType) {
            this.algType = algType;
            return this;
        }

        public AirCertConfig build() {
            if (TextUtils.isEmpty(serverAddress) || TextUtils.isEmpty(vhsmAddress)) {
                throw new IllegalStateException("address == null");
            }
            return new AirCertConfig(this);
        }
    }
}
