package com.xdja.aircert.sdk.config;

import android.support.annotation.IntDef;

/**
 * @author: lyl
 * desc:
 * 2020/11/2
 */
public class AirCertConstant {
    /**
     * 内置芯片类型
     */
    public static final int DEV_TYPE_CHIP = 1;
    /**
     * TF卡
     */
    public static final int DEV_TYPE_TF_CARD = 2;
    /**
     * 贴膜卡
     */
    public static final int DEV_TYPE_SIM_CARD = 3;
    /**
     * VHSM
     */
    public static final int DEV_TYPE_VHSM = 4;
    /**
     * SM2证书类型单证
     */
    public static final int CERT_TYPE_SM2 = 1;
    /**
     * SM2证书类型双证
     */
    public static final int CERT_TYPE_SM2_DOUBLE = 2;
    /**
     * RSA证书类型
     */
    public static final int CERT_TYPE_RSA = 3;

    @IntDef({DEV_TYPE_CHIP, DEV_TYPE_TF_CARD, DEV_TYPE_SIM_CARD, DEV_TYPE_VHSM})
    public @interface DEV_TYPE {
    }

    @IntDef({CERT_TYPE_SM2, CERT_TYPE_SM2_DOUBLE, CERT_TYPE_RSA})
    public @interface CERT_TYPE {
        
    }
}
