/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.sdk.config;

import android.text.TextUtils;
import com.xdja.aircert.sdk.config.AirCertConstant;

public final class AirCertConfig {
    private String serverAddress;
    private String vhsmAddress;
    private int containerNum;
    @AirCertConstant.DEV_TYPE
    private int certType;
    @AirCertConstant.CERT_TYPE
    private int algType;

    private AirCertConfig(Builder builder) {
        this.serverAddress = builder.serverAddress;
        this.vhsmAddress = builder.vhsmAddress;
        this.containerNum = builder.containerNum;
        this.certType = builder.certType == 0 ? 2 : builder.certType;
        this.algType = builder.algType == 0 ? 4 : builder.algType;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getVhsmAddress() {
        return this.vhsmAddress;
    }

    public int getContainerNum() {
        return this.containerNum;
    }

    public int getCertType() {
        return this.certType;
    }

    public int getAlgType() {
        return this.algType;
    }

    public static class Builder {
        private String serverAddress;
        private String vhsmAddress;
        private int containerNum;
        @AirCertConstant.DEV_TYPE
        private int certType;
        @AirCertConstant.CERT_TYPE
        private int algType;

        public Builder setServerAddress(String serverAddress) {
            if (TextUtils.isEmpty((CharSequence)serverAddress)) {
                throw new IllegalStateException("serverAddress == null");
            }
            this.serverAddress = serverAddress;
            return this;
        }

        public Builder setVhsmAddress(String vhsmAddress) {
            if (TextUtils.isEmpty((CharSequence)vhsmAddress)) {
                throw new IllegalStateException("vhsmAddress == null");
            }
            this.vhsmAddress = vhsmAddress;
            return this;
        }

        public Builder setContainerNum(int containerNum) {
            this.containerNum = containerNum;
            return this;
        }

        public Builder setCertType(@AirCertConstant.DEV_TYPE int certType) {
            this.certType = certType;
            return this;
        }

        public Builder setAlgType(@AirCertConstant.CERT_TYPE int algType) {
            this.algType = algType;
            return this;
        }

        public AirCertConfig build() {
            if (TextUtils.isEmpty((CharSequence)this.serverAddress) || TextUtils.isEmpty((CharSequence)this.vhsmAddress)) {
                throw new IllegalStateException("address == null");
            }
            return new AirCertConfig(this);
        }
    }
}

