/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.sdk.device;

import com.xdja.aircert.sdk.AirCertSdk;
import com.xdja.aircert.sdk.config.AirCertConstant;
import com.xdja.aircert.sdk.device.NetVHSMHandle;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.driver.xdja.XdjaDevExtraInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeviceWrapper {
    public static CryptoDevInfo getCurrentDevInfo() {
        if (AirCertSdk.getsInstance().getAirCertConfig().getCertType() == 4) {
            return DeviceWrapper.getVhsmCryptoDev();
        }
        Map<Integer, CryptoDevInfo> devInfoMap = DeviceWrapper.getDevInfo();
        if (devInfoMap == null || devInfoMap.size() == 0) {
            return null;
        }
        return devInfoMap.get(DeviceWrapper.getDeviceCryType(AirCertSdk.getsInstance().getAirCertConfig().getCertType()).getType());
    }

    public static CryptoDevInfo getVhsmCryptoDev() {
        CryptoDevInfo vhsmInfo = new CryptoDevInfo();
        vhsmInfo.setCardId(NetVHSMHandle.getNetVhsmCardId(AirCertSdk.getsInstance().getContext()));
        vhsmInfo.setDriver("ChipManagerDriver");
        vhsmInfo.setType(CryptoDevType.DEV_TYPE_Soft);
        XdjaDevExtraInfo extraInfo = new XdjaDevExtraInfo();
        vhsmInfo.setPrivateData((Object)extraInfo.setType(32));
        return vhsmInfo;
    }

    public static CryptoDevType getDeviceCryType(@AirCertConstant.DEV_TYPE int certType) {
        switch (certType) {
            case 1: {
                return CryptoDevType.DEV_TYPE_Chip;
            }
            case 2: {
                return CryptoDevType.DEV_TYPE_SdCard;
            }
            case 3: {
                return CryptoDevType.DEV_TYPE_SimKey;
            }
            case 4: {
                return CryptoDevType.DEV_TYPE_Soft;
            }
        }
        return CryptoDevType.DEV_TYPE_Soft;
    }

    public static Map<Integer, CryptoDevInfo> getDevInfo() {
        DeviceWrapper.scanningDevice();
        HashMap<Integer, CryptoDevInfo> infoMap = new HashMap<Integer, CryptoDevInfo>();
        List<CryptoDevInfo> devList = DeviceWrapper.getDeviceList();
        if (devList == null || devList.size() <= 0) {
            return infoMap;
        }
        for (CryptoDevInfo devInfo : devList) {
            switch (devInfo.getType()) {
                case DEV_TYPE_SdCard: {
                    infoMap.put(CryptoDevType.DEV_TYPE_SdCard.getType(), devInfo);
                    break;
                }
                case DEV_TYPE_Chip: {
                    infoMap.put(CryptoDevType.DEV_TYPE_Chip.getType(), devInfo);
                    break;
                }
                case DEV_TYPE_SimKey: {
                    infoMap.put(CryptoDevType.DEV_TYPE_SimKey.getType(), devInfo);
                    break;
                }
                case DEV_TYPE_Soft: {
                    infoMap.put(CryptoDevType.DEV_TYPE_Soft.getType(), devInfo);
                    break;
                }
            }
        }
        return infoMap;
    }

    private static void scanningDevice() {
        boolean isScanningDevice = CryptoDevManager.getInstance().isScanning();
        while (isScanningDevice) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            isScanningDevice = CryptoDevManager.getInstance().isScanning();
        }
    }

    private static List<CryptoDevInfo> getDeviceList() {
        List devList = CryptoDevManager.getInstance().getCryptoDevInfos();
        if (devList.size() <= 0) {
            return null;
        }
        return devList;
    }
}

