/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.sdk.net;

import com.xdja.aircert.sdk.AirCertSdk;
import com.xdja.aircert.sdk.R;
import com.xdja.aircert.sdk.device.DeviceWrapper;
import com.xdja.aircert.sdk.net.HttpUrl;
import com.xdja.cryptodev.CryptoDevInfo;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class HttpClientManager {
    private static final int READ_TIMEOUT = 20;
    private static final int WRITE_TIMEOUT = 20;
    private static final int CONNECTION_TIMEOUT = 20;
    private static HttpClientManager sInstance;
    private OkHttpClient httpClient;
    private static CryptoDevInfo cacheCryptoDevInfo;

    public OkHttpClient getHttpClient() {
        if (null == this.httpClient) {
            this.initHttp();
        }
        return this.httpClient;
    }

    private HttpClientManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpClientManager getInstance() {
        if (null != sInstance) return sInstance;
        Class<HttpClientManager> clazz = HttpClientManager.class;
        synchronized (HttpClientManager.class) {
            if (null != sInstance) return sInstance;
            sInstance = new HttpClientManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void initHttp() {
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
        builder.connectTimeout(20L, TimeUnit.SECONDS);
        builder.readTimeout(20L, TimeUnit.SECONDS);
        builder.writeTimeout(20L, TimeUnit.SECONDS);
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, this.configHttpsAttribute(), null);
            builder.sslSocketFactory(sslContext.getSocketFactory(), new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            });
            builder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            this.httpClient = builder.build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private TrustManager[] configHttpsAttribute() {
        try {
            KeyStore serverKeyStore = KeyStore.getInstance("bks");
            InputStream inputStream = AirCertSdk.getsInstance().getContext().getResources().openRawResource(R.raw.truststore);
            serverKeyStore.load(inputStream, "xdja1234".toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(serverKeyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Request initRequest(String url, String jsonStr) {
        Request.Builder builder = new Request.Builder();
        if (cacheCryptoDevInfo == null && (cacheCryptoDevInfo = DeviceWrapper.getCurrentDevInfo()) == null) {
            throw new NullPointerException("cardNum");
        }
        builder.addHeader("Content-Type", "application/json").addHeader("cardNo", HttpClientManager.cacheCryptoDevInfo.cardId).addHeader("clientTime", String.valueOf(System.currentTimeMillis())).url(HttpUrl.getUrl(url));
        if (jsonStr != null) {
            MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)jsonStr);
            builder.post(body);
        }
        return builder.build();
    }
}

