package com.xdja.aircert.sdk.device;

import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.os.Message;
import android.provider.Settings;
import android.util.Log;

import com.xdja.aircert.sdk.util.SdkLog;
import com.xdja.initvhsm.net.NetRespository;
import com.xdja.initvhsm.utils.NetVhsmCardIdUtil;
import com.xdja.initvhsm.utils.NetVhsmDeviceIdUtils;

import java.io.File;

/**
 * 联网卡VHSM相关操作
 * Created by jff on 2019/7/8.
 */
public class NetVHSMHandle {
    private static final String FILE_DIR = "xdja/vhsm/net/";
    private static final String RAND_FILE_PATH = FILE_DIR + "rand.bin";
    private static final String KDAT_FILE_PATH = FILE_DIR + "vhsm.dat";
    private static final String WBOX_FILE_PATH = FILE_DIR + "wbox.lib";
    private static final String VHSM_LIB_FILE_PATH = FILE_DIR + "vhsm.lib";

    /**
     * 获取VHSM卡号
     *
     * @return VHSM卡号
     */
    public static String getNetVhsmCardId(Context context) {
        String netVhsmCardId = NetVhsmCardIdUtil.getCardId(NetVhsmDeviceIdUtils.getDevId(context));
        return netVhsmCardId;
    }

    /**
     * vhsm初始化
     *
     * @param context
     * @return 初始化结果 true 初始化成功
     */
    public static boolean initVHSM(final Context context, String ipPort) {
        final String[] address = ipPort.split(":");
        if (address.length != 2) {
            throw new IllegalArgumentException("vhsmipport error");
        }
        NetRespository netRespository = NetRespository.create(context, address[0], Integer.parseInt(address[1]));
        int initResult = netRespository.init(NetVhsmDeviceIdUtils.getDevId(context));
        Log.e("jff", "37 NetVHSMHandle run :initResult =  " + initResult);
        if (initResult == 0) {
            //联网版VHSM初始化成功
            SdkLog.logi("VHSM初始化成功");
            int initFile = NetRespository.initVhsmlibFile(context, address[0], Integer.parseInt(address[1]));
            if (initFile == 0) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }


    /**
     * VHSM是否可用,联网激活
     *
     * @return
     */
    public static boolean isNetVHSMCanUse() {
        File storageDir = Environment.getExternalStorageDirectory();
        File randFile = new File(storageDir, RAND_FILE_PATH);
        if (!randFile.exists()) {
            return false;
        }
        File wboxFile = new File(storageDir, WBOX_FILE_PATH);
        if (!wboxFile.exists()) {
            return false;
        }
        File kdatFile = new File(storageDir, KDAT_FILE_PATH);
        if (!kdatFile.exists()) {
            return false;
        }
        File vhsmLibFile = new File(storageDir, VHSM_LIB_FILE_PATH);
        if (!vhsmLibFile.exists()) {
            return false;
        }
        return true;
    }

}
