package com.xdja.aircert.sdk;

import android.app.Application;
import android.content.Context;

import com.xdja.aircert.sdk.config.AirCertConfig;
import com.xdja.aircert.sdk.config.AirCertConstant;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerDriver;

/**
 * @author: lyl
 * desc:sdk 初始化
 * 2020/11/2
 */
public class AirCertSdk {
    private static AirCertSdk sInstance;
    private AirCertConfig airCertConfig;

    public AirCertConfig getAirCertConfig() {
        return airCertConfig;
    }

    private Context context;
    private AirCertSdk() {
    }

    public static AirCertSdk getsInstance() {
        if (null == sInstance) {
            synchronized (AirCertSdk.class) {
                if (null == sInstance) {
                    sInstance = new AirCertSdk();
                }
            }
        }
        return sInstance;
    }

    public void init(Application application, AirCertConfig config) {
        this.airCertConfig = config;
        this.context = application;
        initCryptoDev(application);
    }

    public Context getContext() {
        return context;
    }

    private void initCryptoDev(Context context) {
        CryptoDevManager cryptoDevManager = CryptoDevManager.getInstance();
        cryptoDevManager.setContext(context);
        try {
            cryptoDevManager.registerDriver(new ChipManagerDriver());
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (airCertConfig.getCardType() == AirCertConstant.DEV_TYPE_VHSM) {
            cryptoDevManager.setDisableSoft(false);
        } else {
            cryptoDevManager.setDisableSoft(true);
        }
    }
}
