package com.xdja.aircert.sdk.data;

import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.xdja.aircert.sdk.bean.CertDetailInfoBean;
import com.xdja.aircert.sdk.data.CertRepository;
import com.xdja.aircert.sdk.data.HttpCallBack;
import com.xdja.aircert.sdk.device.DeviceWrapper;
import com.xdja.aircert.sdk.net.HttpClientManager;
import com.xdja.aircert.sdk.net.HttpUrl;
import com.xdja.aircert.sdk.util.SdkLog;

import org.json.JSONObject;

import okhttp3.Call;
import okhttp3.Request;
import okhttp3.Response;

/**
 * @author: lyl
 * desc:
 * 2020/11/5
 */
public class AirCertService {
    /**
     * 申请证书
     *
     * @param phone
     */
    public static void applyCert(@NonNull String phone, HttpCallBack<CertDetailInfoBean> callBack) {
        if (TextUtils.isEmpty(phone)) {
            throw new IllegalArgumentException("phone null");
        }
        CertRepository.applyCert(phone, callBack);
    }

    /**
     * 获取证书状态
     */
    public static void queryCertState() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("cardType", DeviceWrapper.convertCardType(DeviceWrapper.getCurrentDevInfo().getType().getType()));
            Request requestBody = HttpClientManager.initRequest(HttpUrl.CERT_STATUS, jsonObject.toString());
            Call call = HttpClientManager.getInstance().getHttpClient().newCall(requestBody);
            Response response = call.execute();
            SdkLog.logi(response.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
