package com.xdja.aircert.sdk.device;

import android.text.TextUtils;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.aircert.sdk.AirCertSdk;
import com.xdja.aircert.sdk.cert.CertSKF;
import com.xdja.aircert.sdk.config.CertRule;
import com.xdja.aircert.sdk.config.CertType;
import com.xdja.aircert.sdk.config.XDJAAlgParams;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.multichip.param.CertBean;

import org.bouncycastle.util.encoders.Base64;

import static com.xdja.aircert.sdk.device.DeviceWrapper.getCryptoInstance;

/**
 * @author: lyl
 * desc:读写卡操作
 * 2020/11/10
 */
public class OperateCertHelper {
    /**
     * 将SKF结构的数据写入卡
     *
     * @param type    设备类型
     * @param certStr SKF结构数据
     * @return -4 标识服务端跟客户端的证书机制不一致
     */
    public int importCert(CryptoDevType type, int containerNum, String certStr) {

        String certType = AirCertSdk.getsInstance().getAirCertConfig().getCertType();

        String certRule = CertHelper.getCertRule(AirCertSdk.getsInstance().getAirCertConfig().getAlgType());


//        Log.e("jff", "522 DeviceWrapper importCert : ");
        CertSKF certSKF = splitCertStr(type, containerNum, certStr);
        if (certSKF == null) {
            return -1;
        }
        if (certSKF.getErrorCode() == 4) {
            return -4;
        }
        String pin = CertHelper.getPin();
        int role = CertHelper.getRole(AirCertSdk.getsInstance().getAirCertConfig().getContainerNum());
        CryptoInstance cryptoInstance = getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }

        CertBean bean = null;

        if (CertHelper.getAlgType().equals(XDJAAlgParams.CA_ALG_RSA)) {
            switch (CertHelper.getCertRule(AirCertSdk.getsInstance().getAirCertConfig().getAlgType())) {
                case CertRule.SINGLE:
                    if (AirCertSdk.getsInstance().getAirCertConfig().getCertType().equals(CertType.SIGNING)
                            || TextUtils.isEmpty(AirCertSdk.getsInstance().getAirCertConfig().getCertType())) {
                        bean = CertBean.createSingleRSASignCert(role, pin, containerNum, certSKF.getSignCert());
                    } else {
                        bean = CertBean.createSingleRSAExchangeCert(role, pin, containerNum, certSKF.getEnCodeCert());
                    }
                    break;
                default:
                    break;
            }
        } else {
            switch (CertHelper.getCertRule(AirCertSdk.getsInstance().getAirCertConfig().getAlgType())) {
                case CertRule.SINGLE:
                    if (AirCertSdk.getsInstance().getAirCertConfig().getCertType().equals(CertType.SIGNING)
                            || TextUtils.isEmpty(AirCertSdk.getsInstance().getAirCertConfig().getCertType())) {

                        bean = CertBean.createSingleSM2SignCert(role, pin, containerNum, certSKF.getSignCert());
                    } else {
                        bean = CertBean.createSingleSM2ExchangeCert(role, pin, containerNum, certSKF.getEnCodeCert());
                    }
                    break;
                case CertRule.DOUBLE_CERT:
                    bean = CertBean.createDoubleSM2CertSkf(role, pin, containerNum, certSKF.getSignCert(), certSKF.getEnCodeCert(), certSKF.getKeyPair());
                    break;
                default:
                    break;
            }
        }

//        ModuleLog.e("import cert = " + bean.toString());
        int importCertRet = cryptoInstance.importCert(bean);

        if (importCertRet != 0) {
            return importCertRet;
        }

        int writeProjectLabelRet = writeProjectLabel(type, certSKF.getProjectLabel());
        if (writeProjectLabelRet != 0) {
            return writeProjectLabelRet;
        } else {
            return 0;
        }
    }

    private int writeProjectLabel(CryptoDevType type, String labStr) {
        byte[] labelFid = new byte[]{0x00, (byte) 0x9f};
        CryptoInstance cryptoInstance = getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }

        byte[] labStrBytes = labStr.getBytes();
        int writeLabel = -1;

        int createRet = createFile(type);
        if (createRet == 0 || createRet == 2033) {//创建文件成功或者文件已存在
            writeLabel = cryptoInstance.writeFile(labelFid, 0, 64, labStrBytes);
            //            ModuleLog.e("写标签内容：= " + labSm3Str.getBytes());
        }

        return writeLabel;
    }

    private int createFile(CryptoDevType type) {
        byte[] labelFid = new byte[]{0x00, (byte) 0x9f};

        XDJA_FILE file = new XDJA_FILE();
        file.read_Acl = (byte) 0xf1;
        file.write_Acl = (byte) 0xf1;
        file.room = 0x200;
        file.type = JNIAPI.FILE_BINARY;
        file.id = labelFid;


        CryptoInstance cryptoInstance = getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }

        int ret = cryptoInstance.createFile(file);
        //        ModuleLog.e("创建ret " + ret + " type " + type);
        return ret;
    }

    private CertSKF splitCertStr(CryptoDevType type, int containerNum, String certStr) {

//        ModuleLog.e(certStr);

        if (certStr.equals("") || certStr.length() <= 0) {
            return null;
        }
        //        ModuleLog.e("certStr " + certStr);

        //“cert”: “签名证书Base64#加密证书Base64#加密密钥” //证书信息
        //        certStr = certStr.replaceAll("\r", "");
        //        certStr = certStr.replaceAll("\n", "");
        certStr = certStr.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "");
        certStr = certStr.replace("\r", "").replace("\n", "");
        certStr = certStr.replace("\\r", "").replace("\\n", "");

        //        certStr = certStr.replaceAll("-----BEGIN CERTIFICATE-----", "");
        //        certStr = certStr.replaceAll("-----END CERTIFICATE-----", "");
        String[] pieces = certStr.split("#");
        //        ModuleLog.e("cert分隔后数据长度 " + pieces.length);


//        for (int i = 0; i <= pieces.length - 1; i++) {
//            ModuleLog.e("第" + (i + 1) + "段\n" + pieces[i]);
//        }

        CertSKF certSKF = new CertSKF();

        String certRule = CertHelper.getCertRule(AirCertSdk.getsInstance().getAirCertConfig().getAlgType());

        //如果配置项证书个数跟服务端返回的数据长度不一致
        //todo jff 之后做证书更新这一块应该做相应的变更
        if ((certRule.equals(CertRule.SINGLE) && pieces.length != 2)
                || (certRule.equals(CertRule.DOUBLE_CERT) && pieces.length != 4)) {
            certSKF.setErrorCode(4);
        }

        switch (pieces.length) {
            case 2:  //加密证书base64#项目标签（单证/单证更新延期）
                if (!TextUtils.isEmpty(pieces[0])) {
                    if (TextUtils.isEmpty(AirCertSdk.getsInstance().getAirCertConfig().getCertType())
                            || AirCertSdk.getsInstance().getAirCertConfig().getCertType().equals(CertType.SIGNING)) {

                        certSKF.setSignCert(Base64.decode(pieces[0].getBytes()));
                    } else if (AirCertSdk.getsInstance().getAirCertConfig().getCertType().equals(CertType.ENCRYPT)) {
                        certSKF.setEnCodeCert(Base64.decode(pieces[0].getBytes()));
                    }
                }
                if (!TextUtils.isEmpty(pieces[1])) {
                    certSKF.setProjectLabel(pieces[1]);
                }
                certSKF.setLen(2);
                break;
            case 3://签名证书base64#加密证书base64#项目标签（双证无私钥）
                if (!TextUtils.isEmpty(pieces[0])) {
                    certSKF.setSignCert(Base64.decode(pieces[0].getBytes()));
                }
                if (!TextUtils.isEmpty(pieces[1])) {
                    certSKF.setEnCodeCert(Base64.decode(pieces[1].getBytes()));
                }

                if (!TextUtils.isEmpty(pieces[2])) {
                    certSKF.setProjectLabel(pieces[2]);
                }
                certSKF.setLen(3);
            case 4://签名证书base64#加密证书base64#私钥结构体#项目标签
                if (!TextUtils.isEmpty(pieces[0])) {
                    certSKF.setSignCert(Base64.decode(pieces[0].getBytes()));
                }
                if (!TextUtils.isEmpty(pieces[1])) {
                    certSKF.setEnCodeCert(Base64.decode(pieces[1].getBytes()));
                }

                if (!TextUtils.isEmpty(pieces[2])) {
                    certSKF.setKeyPair(Base64.decode(pieces[2].getBytes()));
                }
                if (!TextUtils.isEmpty(pieces[3])) {
                    certSKF.setProjectLabel(pieces[3]);
                }
                certSKF.setLen(4);
                break;
            default:
                break;
        }
        return certSKF;
    }
}
