package com.xdja.aircert.sdk.util;

import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

import com.xdja.aircert.sdk.AirCertSdk;

/**
 * @author: lyl
 * desc:
 * 2020/11/9
 */
public class DeviceUtil {
    /**
     * 读取SIM卡的imsi
     * author jff
     *
     * @return
     */
    public static String getIMSI() {
        Context context = AirCertSdk.getsInstance().getContext();
        TelephonyManager mTelephonyMgr = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        if (ActivityCompat.checkSelfPermission(context, Manifest.permission.READ_PHONE_STATE) != PackageManager.PERMISSION_GRANTED) {
            return "";
        }
        String imsi = mTelephonyMgr.getSubscriberId();
        return TextUtils.isEmpty(imsi) ? "" : imsi;
    }

    /**
     * 读取设备IMEI
     * author jff
     *
     * @return
     */
    public static String getIMEI() {
        Context context = AirCertSdk.getsInstance().getContext();
        String imei = "";
        imei = Settings.System.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
        return imei;
    }

    /**
     * 获取运营商
     *
     * @return 1.中国移动 ; 2.中国联通; 3.中国电信; 0.代表未知; -1.没有权限获取
     */
    public static int getOperator() {
        String imsi = getIMSI();
        if (TextUtils.isEmpty(imsi)) {
            return -1;
        }
        return getOperatorFromIMSI(imsi);
    }

    /**
     * 获取手机品牌
     *
     * @return
     */
    public static String getBrand() {
        return Build.BRAND;
    }

    private static int getOperatorFromIMSI(String imsi) {
        if (imsi.startsWith("46000") || imsi.startsWith("46002") || imsi.equals("46007")) {
            //移动
            return 1;
        } else if (imsi.startsWith("46001") || imsi.startsWith("46006")) {
            //联通
            return 2;
        } else if (imsi.startsWith("46003") || imsi.startsWith("46005")) {
            //电信
            return 3;
        } else {
            return 0;
        }

    }
}
