package com.xdja.aircert.sdk.util;

import android.util.Log;
/**
 * @author admin
 */
public class SdkLog {
    /**
     * this must be set false before release
     */
    public static boolean DEBUG = true;
    private static String TAG="SdkLog";
    public static void logi(String msg) {
        if (!DEBUG) {
            return;
        }
        String funcName = Thread.currentThread().getStackTrace()[3].getMethodName();
        String lineNum = "" + Thread.currentThread().getStackTrace()[3].getLineNumber();
        Log.i(TAG, "[" + funcName + "," + lineNum + "]" + msg);
    }

    public static void logd(String msg) {
        if (!DEBUG) {
            return;
        }
        String funcName = Thread.currentThread().getStackTrace()[3].getMethodName();
        String lineNum = "" + Thread.currentThread().getStackTrace()[3].getLineNumber();
        Log.d(TAG, "[" + funcName + "," + lineNum + "]" + msg);
    }

    public static void logw(String msg) {
        if (!DEBUG) {
            return;
        }
        String funcName = Thread.currentThread().getStackTrace()[3].getMethodName();
        String lineNum = "" + Thread.currentThread().getStackTrace()[3].getLineNumber();
        Log.w(TAG, "[" + funcName + "," + lineNum + "]" + msg);
    }

    public static void loge(String msg) {
        if (!DEBUG) {
            return;
        }
        String funcName = Thread.currentThread().getStackTrace()[3].getMethodName();
        String lineNum = "" + Thread.currentThread().getStackTrace()[3].getLineNumber();
        Log.e(TAG, "[" + funcName + "," + lineNum + "]" + msg);
    }
}
