/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.sdk.data;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.xdja.aircert.sdk.bean.CertDetailInfoBean;
import com.xdja.aircert.sdk.data.CertRepository;
import com.xdja.aircert.sdk.data.HttpCallBack;
import com.xdja.aircert.sdk.device.DeviceWrapper;
import com.xdja.aircert.sdk.net.HttpClientManager;
import com.xdja.aircert.sdk.util.SdkLog;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.Response;
import org.json.JSONObject;

public class AirCertService {
    public static void applyCert(@NonNull String phone, HttpCallBack<CertDetailInfoBean> callBack) {
        if (TextUtils.isEmpty((CharSequence)phone)) {
            throw new IllegalArgumentException("phone null");
        }
        CertRepository.applyCert(phone, callBack);
    }

    public static void queryCertState() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("cardType", DeviceWrapper.convertCardType(DeviceWrapper.getCurrentDevInfo().getType().getType()));
            Request requestBody = HttpClientManager.initRequest("/airIssue-api/v1/cert/status", jsonObject.toString());
            Call call = HttpClientManager.getInstance().getHttpClient().newCall(requestBody);
            Response response = call.execute();
            SdkLog.logi(response.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

