package com.xdja.aircert.sdk.data;

import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.xdja.aircert.sdk.bean.CertDetailInfoBean;
import com.xdja.aircert.sdk.device.CertHelper;
import com.xdja.aircert.sdk.net.HttpManager;

/**
 * @author: lyl
 * desc:
 * 2020/11/5
 */
public class AirCertService {
    /**
     * 申请证书
     *
     * @param phone
     */
    public static void applyCert(@NonNull final String phone, final HttpCallBack<CertDetailInfoBean> callBack) {
        if (TextUtils.isEmpty(phone)) {
            throw new IllegalArgumentException("phone null");
        }
        HttpManager.getInstance().executor(new Runnable() {
            @Override
            public void run() {
                CertRepository.applyCert(phone, callBack);
            }
        });
    }

    /**
     * 获取证书状态
     */
    public static void queryCertState(final HttpCallBack<Integer> callBack) {
        HttpManager.getInstance().executor(new Runnable() {
            @Override
            public void run() {
                CertRepository.queryCertState(callBack);
            }
        });
    }

    /**
     * 获取证书详情
     *
     * @return
     */
    public static CertDetailInfoBean getCertInfo() {
        return CertHelper.readCertInfo();
    }

    /**
     * 撤销证书
     *
     * @param callBack
     */
    public static void revokeCert(final HttpCallBack<Boolean> callBack) {
        HttpManager.getInstance().executor(new Runnable() {
            @Override
            public void run() {
                CertRepository.revoke(callBack);
            }
        });
    }
}
