package com.xdja.aircert.sdk.util;

import android.text.TextUtils;

import com.xdja.aircert.sdk.AirCertSdk;
import com.xdja.aircert.sdk.config.AirCertConstant;
import com.xdja.aircert.sdk.config.CertRule;
import com.xdja.aircert.sdk.config.CertType;
import com.xdja.aircert.sdk.device.CertHelper;
import com.xdja.cryptodev.CryptoDevType;

/**
 * @author jff
 * @date 2019/4/30
 */

public class FidUtil {

    public static byte[][] getCertFid(int containerNum) {
        byte[][] certFid = new byte[2][2];
        byte[] signCertFid;
        byte[] exchangeCertFid;
        if (containerNum == 0) {
            signCertFid = new byte[]{0x00, 0x2c};  //默认签名证书
            exchangeCertFid = new byte[]{0x00, 0x29};  //交换证书
            certFid[0] = signCertFid;
            certFid[1] = exchangeCertFid;
            return certFid;
        }

        if (containerNum == 1) {
            signCertFid = new byte[]{0x00, 0x33};  //默认签名证书
            exchangeCertFid = new byte[]{0x00, 0x30};  //交换证书
            certFid[0] = signCertFid;
            certFid[1] = exchangeCertFid;
            return certFid;
        }

        if (containerNum == 2) {
            signCertFid = new byte[]{0x00, 0x3A};  //默认签名证书
            exchangeCertFid = new byte[]{0x00, 0x37};  //交换证书
            certFid[0] = signCertFid;
            certFid[1] = exchangeCertFid;
            return certFid;
        }

        if (containerNum == 3) {
            signCertFid = new byte[]{0x00, 0x41};  //默认签名证书
            exchangeCertFid = new byte[]{0x00, 0x3E};  //交换证书
            certFid[0] = signCertFid;
            certFid[1] = exchangeCertFid;
            return certFid;
        }


        if (containerNum == 4) {
            signCertFid = new byte[]{0x00, 0x48};  //默认签名证书
            exchangeCertFid = new byte[]{0x00, 0x45};  //交换证书
            certFid[0] = signCertFid;
            certFid[1] = exchangeCertFid;
            return certFid;
        }
        if (containerNum == 5) {
            signCertFid = new byte[]{0x00, 0x4F};  //默认签名证书
            exchangeCertFid = new byte[]{0x00, 0x4C};  //交换证书
            certFid[0] = signCertFid;
            certFid[1] = exchangeCertFid;
            return certFid;
        }

        if (containerNum == 6) {
            signCertFid = new byte[]{0x00, 0x56};  //默认签名证书
            exchangeCertFid = new byte[]{0x00, 0x53};  //交换证书
            certFid[0] = signCertFid;
            certFid[1] = exchangeCertFid;
            return certFid;
        }
        return null;
    }


    public static byte[][] getKeyPairFid(CryptoDevType type, int containerNum) {
        byte[][] keyPairFid = new byte[2][2];
        byte[] pubKeyFid;
        byte[] priKeyFid;

        String certRule = CertHelper.getCertRule(AirCertSdk.getsInstance().getAirCertConfig().getAlgType());

        String certType =AirCertSdk.getsInstance().getAirCertConfig().getCertType();

        if (containerNum == 0) {
            if (certRule.equals(CertRule.SINGLE)) {
                if (certType.equals(CertType.SIGNING)
                        || TextUtils.isEmpty(certType)) {
                    pubKeyFid = new byte[]{0x00, 0x2d};  //签名公钥
                    priKeyFid = new byte[]{0x00, 0x2e};  //签名私钥
                } else {
                    pubKeyFid = new byte[]{0x00, 0x2a};  //交换公钥
                    priKeyFid = new byte[]{0x00, 0x2b};  //交换私钥
                }
            } else {
                pubKeyFid = new byte[]{0x00, 0x2d};  //签名公钥
                priKeyFid = new byte[]{0x00, 0x2e};  //签名私钥
            }

            keyPairFid[0] = pubKeyFid;
            keyPairFid[1] = priKeyFid;
            return keyPairFid;
        }


        if (containerNum == 1) {
            if (certRule.equals(CertRule.SINGLE)) {
                if (certType.equals(CertType.SIGNING)
                        || TextUtils.isEmpty(certType)) {
                    pubKeyFid = new byte[]{0x00, 0x34};  //签名公钥
                    priKeyFid = new byte[]{0x00, 0x35};  //签名私钥
                } else {
                    pubKeyFid = new byte[]{0x00, 0x31};  //交换公钥
                    priKeyFid = new byte[]{0x00, 0x32};  //交换私钥
                }
            } else {
                pubKeyFid = new byte[]{0x00, 0x34};  //签名公钥
                priKeyFid = new byte[]{0x00, 0x35};  //签名私钥
            }

            keyPairFid[0] = pubKeyFid;
            keyPairFid[1] = priKeyFid;
            return keyPairFid;
        }


        if (containerNum == 2) {
            if (certRule.equals(CertRule.SINGLE)) {
                if (certType.equals(CertType.SIGNING)
                        || TextUtils.isEmpty(certType)) {
                    pubKeyFid = new byte[]{0x00, 0x3b};  //签名公钥
                    priKeyFid = new byte[]{0x00, 0x3c};  //签名私钥
                } else {
                    pubKeyFid = new byte[]{0x00, 0x38};  //交换公钥
                    priKeyFid = new byte[]{0x00, 0x39};  //交换私钥
                }
            } else {
                pubKeyFid = new byte[]{0x00, 0x3b};  //签名公钥
                priKeyFid = new byte[]{0x00, 0x3c};  //签名私钥
            }

            keyPairFid[0] = pubKeyFid;
            keyPairFid[1] = priKeyFid;
            return keyPairFid;
        }

        if (containerNum == 3) {
            if (certRule.equals(CertRule.SINGLE)) {
                if (certType.equals(CertType.SIGNING)
                        || TextUtils.isEmpty(certType)) {
                    pubKeyFid = new byte[]{0x00, 0x42};  //签名公钥
                    priKeyFid = new byte[]{0x00, 0x43};  //签名私钥
                } else {
                    pubKeyFid = new byte[]{0x00, 0x3F};  //交换公钥
                    priKeyFid = new byte[]{0x00, 0x40};  //交换私钥
                }
            } else {
                pubKeyFid = new byte[]{0x00, 0x42};  //签名公钥
                priKeyFid = new byte[]{0x00, 0x43};  //签名私钥
            }

            keyPairFid[0] = pubKeyFid;
            keyPairFid[1] = priKeyFid;
            return keyPairFid;
        }


        if (containerNum == 4) {
            if (certRule.equals(CertRule.SINGLE)) {
                if (certType.equals(CertType.SIGNING)
                        || TextUtils.isEmpty(certType)) {
                    pubKeyFid = new byte[]{0x00, 0x49};  //签名公钥
                    priKeyFid = new byte[]{0x00, 0x4a};  //签名私钥
                } else {
                    pubKeyFid = new byte[]{0x00, 0x46};  //交换公钥
                    priKeyFid = new byte[]{0x00, 0x47};  //交换私钥
                }
            } else {
                pubKeyFid = new byte[]{0x00, 0x49};  //签名公钥
                priKeyFid = new byte[]{0x00, 0x4a};  //签名私钥
            }
            keyPairFid[0] = pubKeyFid;
            keyPairFid[1] = priKeyFid;
            return keyPairFid;
        }


        if (containerNum == 5) {
            if (certRule.equals(CertRule.SINGLE)) {
                if (certType.equals(CertType.SIGNING)
                        || TextUtils.isEmpty(certType)) {
                    pubKeyFid = new byte[]{0x00, 0x50};  //签名公钥
                    priKeyFid = new byte[]{0x00, 0x51};  //签名私钥
                } else {
                    pubKeyFid = new byte[]{0x00, 0x4d};  //交换公钥
                    priKeyFid = new byte[]{0x00, 0x4e};  //交换私钥
                }
            } else {
                pubKeyFid = new byte[]{0x00, 0x50};  //签名公钥
                priKeyFid = new byte[]{0x00, 0x51};  //签名私钥
            }
            keyPairFid[0] = pubKeyFid;
            keyPairFid[1] = priKeyFid;
            return keyPairFid;
        }


        if (containerNum == 6) {
            if (certRule.equals(CertRule.SINGLE)) {
                if (certType.equals(CertType.SIGNING)
                        || TextUtils.isEmpty(certType)) {
                    pubKeyFid = new byte[]{0x00, 0x57};  //签名公钥
                    priKeyFid = new byte[]{0x00, 0x58};  //签名私钥
                } else {
                    pubKeyFid = new byte[]{0x00, 0x54};  //交换公钥
                    priKeyFid = new byte[]{0x00, 0x55};  //交换私钥
                }
            } else {
                pubKeyFid = new byte[]{0x00, 0x57};  //签名公钥
                priKeyFid = new byte[]{0x00, 0x58};  //签名私钥
            }
            keyPairFid[0] = pubKeyFid;
            keyPairFid[1] = priKeyFid;
            return keyPairFid;
        }


        return null;
    }
}
