/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.sdk.data;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.xdja.aircert.sdk.bean.CertDetailInfoBean;
import com.xdja.aircert.sdk.data.CertRepository;
import com.xdja.aircert.sdk.data.HttpCallBack;
import com.xdja.aircert.sdk.device.CertHelper;
import com.xdja.aircert.sdk.net.HttpManager;

public class AirCertService {
    public static void applyCert(final @NonNull String phone, final HttpCallBack<CertDetailInfoBean> callBack) {
        if (TextUtils.isEmpty((CharSequence)phone)) {
            throw new IllegalArgumentException("phone null");
        }
        HttpManager.getInstance().executor(new Runnable(){

            @Override
            public void run() {
                CertRepository.applyCert(phone, callBack);
            }
        });
    }

    public static void queryCertState(final HttpCallBack<Integer> callBack) {
        HttpManager.getInstance().executor(new Runnable(){

            @Override
            public void run() {
                CertRepository.queryCertState(callBack);
            }
        });
    }

    public static CertDetailInfoBean getCertInfo() {
        return CertHelper.readCertInfo();
    }

    public static void revokeCert(final HttpCallBack<Boolean> callBack) {
        HttpManager.getInstance().executor(new Runnable(){

            @Override
            public void run() {
                CertRepository.revoke(callBack);
            }
        });
    }
}

