/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.sdk.device;

import com.xdja.aircert.sdk.AirCertSdk;
import com.xdja.aircert.sdk.bean.CertDetailInfoBean;
import com.xdja.aircert.sdk.config.AirCertConstant;
import com.xdja.aircert.sdk.device.CertHelper;
import com.xdja.aircert.sdk.device.NetVHSMHandle;
import com.xdja.aircert.sdk.util.FidUtil;
import com.xdja.aircert.sdk.util.SdkLog;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.cryptodev.driver.xdja.XdjaDevExtraInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeviceWrapper {
    public static CryptoDevInfo getCurrentDevInfo() {
        if (AirCertSdk.getsInstance().getAirCertConfig().getCardType() == 4) {
            return DeviceWrapper.getVhsmCryptoDev();
        }
        Map<Integer, CryptoDevInfo> devInfoMap = DeviceWrapper.getDevInfo();
        if (devInfoMap == null || devInfoMap.size() == 0) {
            return null;
        }
        return devInfoMap.get(DeviceWrapper.getDeviceCryType(AirCertSdk.getsInstance().getAirCertConfig().getCardType()).getType());
    }

    public static CryptoDevInfo getVhsmCryptoDev() {
        CryptoDevInfo vhsmInfo = new CryptoDevInfo();
        vhsmInfo.setCardId(NetVHSMHandle.getNetVhsmCardId(AirCertSdk.getsInstance().getContext()));
        vhsmInfo.setDriver("ChipManagerDriver");
        vhsmInfo.setType(CryptoDevType.DEV_TYPE_Soft);
        XdjaDevExtraInfo extraInfo = new XdjaDevExtraInfo();
        vhsmInfo.setPrivateData(extraInfo.setType(32));
        return vhsmInfo;
    }

    public static CryptoDevType getDeviceCryType(@AirCertConstant.DEV_TYPE int certType) {
        switch (certType) {
            case 1: {
                return CryptoDevType.DEV_TYPE_Chip;
            }
            case 2: {
                return CryptoDevType.DEV_TYPE_SdCard;
            }
            case 3: {
                return CryptoDevType.DEV_TYPE_SimKey;
            }
            case 4: {
                return CryptoDevType.DEV_TYPE_Soft;
            }
        }
        return CryptoDevType.DEV_TYPE_Soft;
    }

    public static Map<Integer, CryptoDevInfo> getDevInfo() {
        DeviceWrapper.scanningDevice();
        HashMap<Integer, CryptoDevInfo> infoMap = new HashMap<Integer, CryptoDevInfo>();
        List<CryptoDevInfo> devList = DeviceWrapper.getDeviceList();
        if (devList == null || devList.size() <= 0) {
            return infoMap;
        }
        for (CryptoDevInfo devInfo : devList) {
            switch (devInfo.getType()) {
                case DEV_TYPE_SdCard: {
                    infoMap.put(CryptoDevType.DEV_TYPE_SdCard.getType(), devInfo);
                    break;
                }
                case DEV_TYPE_Chip: {
                    infoMap.put(CryptoDevType.DEV_TYPE_Chip.getType(), devInfo);
                    break;
                }
                case DEV_TYPE_SimKey: {
                    infoMap.put(CryptoDevType.DEV_TYPE_SimKey.getType(), devInfo);
                    break;
                }
                case DEV_TYPE_Soft: {
                    infoMap.put(CryptoDevType.DEV_TYPE_Soft.getType(), devInfo);
                    break;
                }
            }
        }
        return infoMap;
    }

    private static void scanningDevice() {
        boolean isScanningDevice = CryptoDevManager.getInstance().isScanning();
        while (isScanningDevice) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            isScanningDevice = CryptoDevManager.getInstance().isScanning();
        }
    }

    private static List<CryptoDevInfo> getDeviceList() {
        List<CryptoDevInfo> devList = CryptoDevManager.getInstance().getCryptoDevInfos();
        if (devList.size() <= 0) {
            return null;
        }
        return devList;
    }

    public CertDetailInfoBean readCertFromContainer(CryptoDevType type, int containerNo) {
        String certType = AirCertSdk.getsInstance().getAirCertConfig().getCertType();
        byte[] fid = null;
        byte[][] certFid = FidUtil.getCertFid(containerNo);
        if (certType.equals("\u7b7e\u540d\u8bc1\u4e66")) {
            fid = certFid[0];
            return this.readCertFromFid(type, fid);
        }
        if (certType.equals("\u52a0\u5bc6\u8bc1\u4e66")) {
            fid = certFid[1];
            return this.readCertFromFid(type, fid);
        }
        CertDetailInfoBean info = this.readCertFromFid(type, certFid[0]);
        if (info == null) {
            info = this.readCertFromFid(type, certFid[1]);
        }
        return info;
    }

    private CertDetailInfoBean readCertFromFid(CryptoDevType type, byte[] fid) {
        byte[] certBuf = new byte[2048];
        int[] certLen = new int[1];
        byte[] bytes = this.readCertBytes(type, fid, certBuf, certLen);
        if (bytes == null) {
            return null;
        }
        return this.readBytesToCert(fid, certBuf, certLen);
    }

    public byte[] readCertBytes(CryptoDevType type, byte[] fid, byte[] certBuf, int[] certLen) {
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return null;
        }
        int result = cryptoInstance.readCert(fid, certBuf, certLen);
        cryptoInstance.close();
        if (result != 0) {
            return null;
        }
        return certBuf;
    }

    private CertDetailInfoBean readBytesToCert(byte[] fid, byte[] certBuf, int[] certLen) {
        if (fid.length == 0 || certBuf.length == 0 || certLen.length == 0) {
            return null;
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd");
            ByteArrayInputStream bin = new ByteArrayInputStream(certBuf);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(bin);
            CertDetailInfoBean certDetailInfo = new CertDetailInfoBean();
            certDetailInfo.setIssuerOrg(cert.getIssuerX500Principal().getName());
            certDetailInfo.setIssuerCn(cert.getIssuerDN().getName());
            certDetailInfo.setSubjectOrg(cert.getSubjectX500Principal().getName());
            certDetailInfo.setSubjectCn(cert.getSubjectDN().getName());
            certDetailInfo.setAlg(cert.getSigAlgName());
            certDetailInfo.setVer(cert.getVersion());
            System.arraycopy(fid, 0, certDetailInfo.getCertId(), 0, 2);
            certDetailInfo.setIndate(formatter.format(cert.getNotBefore()) + " - " + formatter.format(cert.getNotAfter()));
            certDetailInfo.setNotBefore(cert.getNotBefore());
            certDetailInfo.setNotAfter(cert.getNotAfter());
            certDetailInfo.setSn(cert.getSerialNumber().toString(16));
            certDetailInfo.setCertLen(certLen);
            bin.close();
            return certDetailInfo;
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static CryptoInstance getCryptoInstance(CryptoDevType type) {
        CryptoInstance cryptoDev;
        DeviceWrapper.scanningDevice();
        try {
            cryptoDev = CryptoDevManager.getInstance().createInstance("ChipManagerDriver", type);
        }
        catch (Exception e) {
            SdkLog.loge("220 DeviceWrapper getCryptoInstance : " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        if (cryptoDev == null) {
            return null;
        }
        int result = cryptoDev.open();
        if (result != 0) {
            return null;
        }
        return cryptoDev;
    }

    public static int convertCardType(int type) {
        switch (type) {
            case 0: {
                return 3;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 6;
            }
            case 5: {
                return 7;
            }
        }
        return -1;
    }

    public static int verifyPin(CryptoDevType type, int containerNum, String pinInput) {
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        String pin = pinInput.isEmpty() ? "111111" : pinInput;
        int result = cryptoInstance.verifyPIN(pin, CertHelper.getRole(containerNum));
        return result;
    }
}

