/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.sdk.device;

import android.text.TextUtils;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.aircert.sdk.AirCertSdk;
import com.xdja.aircert.sdk.bean.CertDetailInfoBean;
import com.xdja.aircert.sdk.cert.CertSKF;
import com.xdja.aircert.sdk.device.CertHelper;
import com.xdja.aircert.sdk.device.DeviceWrapper;
import com.xdja.aircert.sdk.util.FidUtil;
import com.xdja.aircert.sdk.util.SdkLog;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.multichip.param.CertBean;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import org.bouncycastle.util.encoders.Base64;

public class OperateCertHelper {
    private static final int RSA_ALG_BITS = 2048;

    public int importCert(CryptoDevType type, int containerNum, String certStr) {
        String certType = AirCertSdk.getsInstance().getAirCertConfig().getCertType();
        String certRule = CertHelper.getCertRule(AirCertSdk.getsInstance().getAirCertConfig().getAlgType());
        CertSKF certSKF = this.splitCertStr(type, containerNum, certStr);
        if (certSKF == null) {
            return -1;
        }
        if (certSKF.getErrorCode() == 4) {
            return -4;
        }
        String pin = CertHelper.getPin();
        int role = CertHelper.getRole(AirCertSdk.getsInstance().getAirCertConfig().getContainerNum());
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        CertBean bean = null;
        if (CertHelper.getAlgType().equals("1.0")) {
            switch (CertHelper.getCertRule(AirCertSdk.getsInstance().getAirCertConfig().getAlgType())) {
                case "\u5355\u8bc1": {
                    if (AirCertSdk.getsInstance().getAirCertConfig().getCertType().equals("\u7b7e\u540d\u8bc1\u4e66") || TextUtils.isEmpty((CharSequence)AirCertSdk.getsInstance().getAirCertConfig().getCertType())) {
                        bean = CertBean.createSingleRSASignCert(role, pin, containerNum, certSKF.getSignCert());
                        break;
                    }
                    bean = CertBean.createSingleRSAExchangeCert(role, pin, containerNum, certSKF.getEnCodeCert());
                    break;
                }
            }
        } else {
            switch (CertHelper.getCertRule(AirCertSdk.getsInstance().getAirCertConfig().getAlgType())) {
                case "\u5355\u8bc1": {
                    if (AirCertSdk.getsInstance().getAirCertConfig().getCertType().equals("\u7b7e\u540d\u8bc1\u4e66") || TextUtils.isEmpty((CharSequence)AirCertSdk.getsInstance().getAirCertConfig().getCertType())) {
                        bean = CertBean.createSingleSM2SignCert(role, pin, containerNum, certSKF.getSignCert());
                        break;
                    }
                    bean = CertBean.createSingleSM2ExchangeCert(role, pin, containerNum, certSKF.getEnCodeCert());
                    break;
                }
                case "\u53cc\u8bc1": {
                    bean = CertBean.createDoubleSM2CertSkf(role, pin, containerNum, certSKF.getSignCert(), certSKF.getEnCodeCert(), certSKF.getKeyPair());
                    break;
                }
            }
        }
        int importCertRet = cryptoInstance.importCert(bean);
        if (importCertRet != 0) {
            return importCertRet;
        }
        int writeProjectLabelRet = this.writeProjectLabel(type, certSKF.getProjectLabel());
        if (writeProjectLabelRet != 0) {
            return writeProjectLabelRet;
        }
        return 0;
    }

    private int writeProjectLabel(CryptoDevType type, String labStr) {
        byte[] labelFid = new byte[]{0, -97};
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        byte[] labStrBytes = labStr.getBytes();
        int writeLabel = -1;
        int createRet = this.createFile(type);
        if (createRet == 0 || createRet == 2033) {
            writeLabel = cryptoInstance.writeFile(labelFid, 0, 64, labStrBytes);
        }
        return writeLabel;
    }

    private int createFile(CryptoDevType type) {
        byte[] labelFid = new byte[]{0, -97};
        XDJA_FILE file = new XDJA_FILE();
        file.read_Acl = (byte)-15;
        file.write_Acl = (byte)-15;
        file.room = (short)512;
        file.type = 1;
        file.id = labelFid;
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        int ret = cryptoInstance.createFile(file);
        return ret;
    }

    private CertSKF splitCertStr(CryptoDevType type, int containerNum, String certStr) {
        if (certStr.equals("") || certStr.length() <= 0) {
            return null;
        }
        certStr = certStr.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "");
        certStr = certStr.replace("\r", "").replace("\n", "");
        certStr = certStr.replace("\\r", "").replace("\\n", "");
        String[] pieces = certStr.split("#");
        CertSKF certSKF = new CertSKF();
        String certRule = CertHelper.getCertRule(AirCertSdk.getsInstance().getAirCertConfig().getAlgType());
        if (certRule.equals("\u5355\u8bc1") && pieces.length != 2 || certRule.equals("\u53cc\u8bc1") && pieces.length != 4) {
            certSKF.setErrorCode(4);
        }
        switch (pieces.length) {
            case 2: {
                if (!TextUtils.isEmpty((CharSequence)pieces[0])) {
                    if (TextUtils.isEmpty((CharSequence)AirCertSdk.getsInstance().getAirCertConfig().getCertType()) || AirCertSdk.getsInstance().getAirCertConfig().getCertType().equals("\u7b7e\u540d\u8bc1\u4e66")) {
                        certSKF.setSignCert(Base64.decode((byte[])pieces[0].getBytes()));
                    } else if (AirCertSdk.getsInstance().getAirCertConfig().getCertType().equals("\u52a0\u5bc6\u8bc1\u4e66")) {
                        certSKF.setEnCodeCert(Base64.decode((byte[])pieces[0].getBytes()));
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[1])) {
                    certSKF.setProjectLabel(pieces[1]);
                }
                certSKF.setLen(2);
                break;
            }
            case 3: {
                if (!TextUtils.isEmpty((CharSequence)pieces[0])) {
                    certSKF.setSignCert(Base64.decode((byte[])pieces[0].getBytes()));
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[1])) {
                    certSKF.setEnCodeCert(Base64.decode((byte[])pieces[1].getBytes()));
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[2])) {
                    certSKF.setProjectLabel(pieces[2]);
                }
                certSKF.setLen(3);
            }
            case 4: {
                if (!TextUtils.isEmpty((CharSequence)pieces[0])) {
                    certSKF.setSignCert(Base64.decode((byte[])pieces[0].getBytes()));
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[1])) {
                    certSKF.setEnCodeCert(Base64.decode((byte[])pieces[1].getBytes()));
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[2])) {
                    certSKF.setKeyPair(Base64.decode((byte[])pieces[2].getBytes()));
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[3])) {
                    certSKF.setProjectLabel(pieces[3]);
                }
                certSKF.setLen(4);
                break;
            }
        }
        return certSKF;
    }

    public String getSn(CryptoDevType type, int containerNum, String certStr) {
        CertDetailInfoBean info;
        CertSKF certSKF = this.splitCertStr(type, containerNum, certStr);
        if (certSKF == null) {
            return "";
        }
        byte[][] fid = FidUtil.getCertFid(containerNum);
        if (AirCertSdk.getsInstance().getAirCertConfig().getCertType().equals("\u7b7e\u540d\u8bc1\u4e66") || TextUtils.isEmpty((CharSequence)AirCertSdk.getsInstance().getAirCertConfig().getCertType())) {
            byte[] signCert = certSKF.getSignCert();
            int signCertLen = signCert != null ? signCert.length : 0;
            int[] signCodeCertLen = new int[]{signCertLen};
            info = OperateCertHelper.readBytesToCert(fid[0], signCert, signCodeCertLen);
        } else {
            byte[] encodeCert = certSKF.getEnCodeCert();
            int encodeCertLen = encodeCert != null ? encodeCert.length : 0;
            int[] enCodeCertLen = new int[]{encodeCertLen};
            info = OperateCertHelper.readBytesToCert(fid[1], encodeCert, enCodeCertLen);
        }
        if (info == null) {
            return "";
        }
        return info.getSn();
    }

    private static CertDetailInfoBean readBytesToCert(byte[] fid, byte[] certBuf, int[] certLen) {
        if (fid.length == 0 || certBuf.length == 0 || certLen.length == 0) {
            return null;
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd");
            SimpleDateFormat formatterValid = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
            ByteArrayInputStream bin = new ByteArrayInputStream(certBuf);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(bin);
            CertDetailInfoBean certDetailInfo = new CertDetailInfoBean();
            certDetailInfo.setIssuerOrg(cert.getIssuerX500Principal().getName());
            certDetailInfo.setIssuerCn(cert.getIssuerDN().getName());
            certDetailInfo.setSubjectOrg(cert.getSubjectX500Principal().getName());
            certDetailInfo.setSubjectCn(cert.getSubjectDN().getName());
            certDetailInfo.setAlg(cert.getSigAlgName());
            certDetailInfo.setVer(cert.getVersion());
            System.arraycopy(fid, 0, certDetailInfo.getCertId(), 0, 2);
            certDetailInfo.setIndate(formatter.format(cert.getNotBefore()) + " - " + formatter.format(cert.getNotAfter()));
            certDetailInfo.setNotBefore(cert.getNotBefore());
            certDetailInfo.setNotAfter(cert.getNotAfter());
            certDetailInfo.setSn(cert.getSerialNumber().toString(16));
            certDetailInfo.setCertLen(certLen);
            bin.close();
            return certDetailInfo;
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String signData(CryptoDevType type, int containerNum, String str) {
        byte[] signData;
        if (str.equals("")) {
            return null;
        }
        byte[][] keyPair = FidUtil.getKeyPairFid(type, containerNum);
        byte[] pubFid = keyPair[0];
        byte[] priFid = keyPair[1];
        int[] signDataLen = new int[1];
        byte[] certInfoBytes = str.getBytes();
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            SdkLog.loge("\u5f85\u7b7e\u540d\u4fe1\u606f cryptoInstance = null");
            return null;
        }
        int ret = DeviceWrapper.verifyPin(type, containerNum, "");
        if (ret != 0) {
            return "errorCode" + CryptoDevManager.getInstance().getErrorText(ret);
        }
        if (CertHelper.getAlgType().equals("1.0")) {
            signData = new byte[256];
            ret = cryptoInstance.RSASign(2048, priFid, 1, certInfoBytes, certInfoBytes.length, signData, signDataLen);
        } else {
            signData = new byte[64];
            ret = cryptoInstance.SM2Sign(pubFid, priFid, 1, certInfoBytes, certInfoBytes.length, signData, signDataLen);
        }
        byte[] data = new byte[signDataLen[0]];
        System.arraycopy(signData, 0, data, 0, data.length);
        if (ret == 0) {
            return new String(Base64.encode((byte[])data));
        }
        return "";
    }

    public static CertDetailInfoBean readCertFromContainer(CryptoDevType type, int containerNo, String certType) {
        byte[] fid = null;
        byte[][] certFid = FidUtil.getCertFid(containerNo);
        if (certType.equals("\u7b7e\u540d\u8bc1\u4e66")) {
            fid = certFid[0];
            return OperateCertHelper.readCertFromFid(type, fid);
        }
        if (certType.equals("\u52a0\u5bc6\u8bc1\u4e66")) {
            fid = certFid[1];
            return OperateCertHelper.readCertFromFid(type, fid);
        }
        CertDetailInfoBean info = OperateCertHelper.readCertFromFid(type, certFid[0]);
        if (info == null) {
            info = OperateCertHelper.readCertFromFid(type, certFid[1]);
        }
        return info;
    }

    private static CertDetailInfoBean readCertFromFid(CryptoDevType type, byte[] fid) {
        byte[] certBuf = new byte[2048];
        int[] certLen = new int[1];
        byte[] bytes = OperateCertHelper.readCertBytes(type, fid, certBuf, certLen);
        if (bytes == null) {
            return null;
        }
        return OperateCertHelper.readBytesToCert(fid, certBuf, certLen);
    }

    private static byte[] readCertBytes(CryptoDevType type, byte[] fid, byte[] certBuf, int[] certLen) {
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return null;
        }
        int result = cryptoInstance.readCert(fid, certBuf, certLen);
        cryptoInstance.close();
        if (result != 0) {
            return null;
        }
        return certBuf;
    }

    public static int clearContainer(CryptoDevType type, int containerNum) {
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        int certRole = CertHelper.getRole(containerNum);
        String pinCode = CertHelper.getPin();
        int ret = cryptoInstance.verifyPIN(pinCode, certRole);
        if (ret == 0) {
            ret = cryptoInstance.clearContainer(certRole, pinCode, containerNum);
        }
        return ret;
    }
}

