/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptodev;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.cryptodev.CryptoDevFactory;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.DeviceListener;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.cryptodev.driver.DriverDevChangedListener;
import com.xdja.cryptodev.driver.IDevDriver;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerError;
import com.xdja.cryptodev.driver.koal.KoalError;
import com.xdja.cryptodev.driver.skf.SkfError;
import com.xdja.cryptodev.driver.xdja.XdjaError;
import com.xdja.cryptodev.error.ErrorCallback;
import com.xdja.cryptodev.error.SysError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 N2\u00020\u0001:\u0001NB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010-J\u0012\u0010(\u001a\u0004\u0018\u00010)2\b\u0010.\u001a\u0004\u0018\u00010\u0007J\u0012\u0010(\u001a\u0004\u0018\u00010)2\b\u0010/\u001a\u0004\u0018\u000100J\u001c\u0010(\u001a\u0004\u0018\u00010)2\b\u00101\u001a\u0004\u0018\u0001002\b\u0010,\u001a\u0004\u0018\u00010-J\u0006\u00102\u001a\u000203J\b\u00104\u001a\u0004\u0018\u00010\u0004J\u0010\u00105\u001a\u0004\u0018\u0001002\u0006\u00106\u001a\u00020\u000bJ\u000e\u00107\u001a\u00020\u001a2\u0006\u00106\u001a\u00020\u000bJ\"\u00108\u001a\u0002032\b\u00101\u001a\u0004\u0018\u0001002\u0006\u00109\u001a\u00020-2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u0010:\u001a\u0002032\u0006\u0010;\u001a\u00020\u0007H\u0016J \u0010:\u001a\u0002032\u0006\u00101\u001a\u00020\u00142\u0006\u00109\u001a\u00020-2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u0010<\u001a\u0002032\u0006\u0010;\u001a\u00020\u0007H\u0016J \u0010<\u001a\u0002032\u0006\u00101\u001a\u00020\u00142\u0006\u00109\u001a\u00020-2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u0010=\u001a\u0002032\u0006\u00101\u001a\u00020\u0014H\u0016J\u0006\u0010>\u001a\u000203J\u000e\u0010?\u001a\u0002032\u0006\u0010@\u001a\u00020\u0012J\u000e\u0010A\u001a\u0002032\u0006\u00101\u001a\u00020\u0014J\u0010\u0010B\u001a\u0002032\b\u0010C\u001a\u0004\u0018\u00010DJ!\u0010E\u001a\u0002HF\"\u0004\b\u0000\u0010F2\f\u0010G\u001a\b\u0012\u0004\u0012\u0002HF0HH\u0002\u00a2\u0006\u0002\u0010IJ\u0010\u0010J\u001a\u0002032\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u000e\u0010K\u001a\u0002032\u0006\u0010@\u001a\u00020\u0012J\u000e\u0010L\u001a\u0002032\u0006\u0010M\u001a\u000200R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001c\"\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u001a\u0010!\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001c\"\u0004\b#\u0010\u001fR\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006O"}, d2={"Lcom/xdja/cryptodev/CryptoDevManager;", "Lcom/xdja/cryptodev/driver/DriverDevChangedListener;", "()V", "context", "Landroid/content/Context;", "cryptoDevInfos", "", "Lcom/xdja/cryptodev/CryptoDevInfo;", "getCryptoDevInfos", "()Ljava/util/List;", "devCount", "", "getDevCount", "()I", "devList", "Ljava/util/Vector;", "deviceListeners", "Ljava/util/ArrayList;", "Lcom/xdja/cryptodev/DeviceListener;", "drivers", "Lcom/xdja/cryptodev/driver/IDevDriver;", "errorManager", "Lcom/xdja/cryptodev/error/SysError;", "handlerThread", "Landroid/os/HandlerThread;", "<set-?>", "", "isDestroying", "()Z", "isDisableSoft", "setDisableSoft", "(Z)V", "isScanning", "logDetail", "getLogDetail", "setLogDetail", "myHandler", "Landroid/os/Handler;", "getMyHandler", "()Landroid/os/Handler;", "createInstance", "Lcom/xdja/cryptodev/devapi/CryptoInstance;", "factory", "Lcom/xdja/cryptodev/CryptoDevFactory;", "type", "Lcom/xdja/cryptodev/CryptoDevType;", "info", "cardId", "", "driver", "destroy", "", "getContext", "getErrorText", "errCode", "isErrorRegistered", "notifyDeviceAdded", "devType", "onDriverDeviceAdded", "devInfo", "onDriverDeviceRemoved", "onDriverRefreshed", "refresh", "registerDeviceListener", "listener", "registerDriver", "registerError", "errorCallback", "Lcom/xdja/cryptodev/error/ErrorCallback;", "runAfterDeviceCheck", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "setContext", "unregisterDeviceListener", "unregisterDriver", "driverName", "Companion", "crypto_release"})
public final class CryptoDevManager
implements DriverDevChangedListener {
    private Context context;
    private final ArrayList<IDevDriver> drivers = new ArrayList();
    private final Vector<CryptoDevInfo> devList = new Vector();
    private final ArrayList<DeviceListener> deviceListeners = new ArrayList();
    private final HandlerThread handlerThread = new HandlerThread("cryptodev_thread");
    @NotNull
    private final Handler myHandler;
    private boolean isDisableSoft;
    private final SysError errorManager = new SysError();
    private boolean isScanning;
    private boolean isDestroying;
    private boolean logDetail;
    private static CryptoDevManager manager;
    private static final String THIS_FILE = "CryptoDevManager";
    public static final Companion Companion;

    @NotNull
    public final Handler getMyHandler() {
        return this.myHandler;
    }

    public final boolean isDisableSoft() {
        return this.isDisableSoft;
    }

    public final void setDisableSoft(boolean bl) {
        this.isDisableSoft = bl;
    }

    public final boolean isScanning() {
        return this.isScanning;
    }

    public final boolean isDestroying() {
        return this.isDestroying;
    }

    public final boolean getLogDetail() {
        return this.logDetail;
    }

    public final void setLogDetail(boolean bl) {
        this.logDetail = bl;
    }

    public final void registerError(@Nullable ErrorCallback errorCallback) {
        ErrorCallback errorCallback2 = errorCallback;
        if (errorCallback2 == null) {
            Intrinsics.throwNpe();
        }
        this.errorManager.registerError(errorCallback2);
    }

    @Nullable
    public final String getErrorText(int errCode) {
        return this.errorManager.getErrorText(errCode);
    }

    public final boolean isErrorRegistered(int errCode) {
        return this.errorManager.isErrorRegistered(errCode);
    }

    public final void setContext(@Nullable Context context) {
        this.context = context;
        this.errorManager.setContext(context);
    }

    @Nullable
    public final Context getContext() {
        return this.context;
    }

    private final <R> R runAfterDeviceCheck(Function0<? extends R> block) {
        boolean isDestroying = CryptoDevManager.Companion.getInstance().isDestroying;
        boolean isScanningDevice = CryptoDevManager.Companion.getInstance().isScanning;
        while (isScanningDevice || isDestroying) {
            try {
                Thread.sleep(15L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            isScanningDevice = CryptoDevManager.Companion.getInstance().isScanning;
            isDestroying = CryptoDevManager.Companion.getInstance().isDestroying;
        }
        Log.d((String)THIS_FILE, (String)("Device check over. Current device list size " + this.devList.size()));
        return (R)block.invoke();
    }

    public final void refresh() {
        this.myHandler.post(new Runnable(this){
            final /* synthetic */ CryptoDevManager this$0;

            public final void run() {
                boolean status = false;
                CryptoDevManager.access$setScanning$p(this.this$0, true);
                CryptoDevManager.access$getDevList$p(this.this$0).clear();
                for (IDevDriver drv : CryptoDevManager.access$getDrivers$p(this.this$0)) {
                    drv.refresh();
                    CryptoDevManager.access$getDevList$p(this.this$0).addAll((Collection)drv.getDevInfos());
                }
                CryptoDevManager.access$setScanning$p(this.this$0, false);
            }
            {
                this.this$0 = cryptoDevManager;
            }
        });
    }

    public final void registerDeviceListener(@NotNull DeviceListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Log.d((String)THIS_FILE, (String)("Add device listener " + listener));
        if (!this.deviceListeners.contains(listener)) {
            this.deviceListeners.add(listener);
        }
    }

    public final void unregisterDeviceListener(@NotNull DeviceListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Log.d((String)THIS_FILE, (String)("Remove device listener " + listener));
        this.deviceListeners.remove(listener);
    }

    public final void registerDriver(@NotNull IDevDriver driver) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        this.myHandler.post(new Runnable(this, driver){
            final /* synthetic */ CryptoDevManager this$0;
            final /* synthetic */ IDevDriver $driver;

            public final void run() {
                CryptoDevManager.access$setScanning$p(this.this$0, true);
                for (IDevDriver drv : CryptoDevManager.access$getDrivers$p(this.this$0)) {
                    if (!Intrinsics.areEqual((Object)drv.getDriverName(), (Object)this.$driver.getDriverName())) continue;
                    Log.d((String)"CryptoDevManager", (String)("Driver " + drv.getDriverName() + " already registered"));
                    CryptoDevManager.access$setScanning$p(this.this$0, false);
                    return;
                }
                int status = this.$driver.init();
                if (status != 0) {
                    Log.e((String)"CryptoDevManager", (String)("Driver " + this.$driver.getDriverName() + " init error. ret " + status));
                    this.$driver.destroy();
                    CryptoDevManager.access$setScanning$p(this.this$0, false);
                    return;
                }
                CryptoDevManager cryptoDevManager = CryptoDevManager.access$getManager$cp();
                if (cryptoDevManager == null) {
                    Intrinsics.throwNpe();
                }
                this.$driver.registerDevChangedListener(cryptoDevManager);
                CryptoDevManager.access$getDevList$p(this.this$0).addAll((Collection)this.$driver.getDevInfos());
                Log.d((String)"CryptoDevManager", (String)("Total dev list size " + CryptoDevManager.access$getDevList$p(this.this$0).size()));
                CryptoDevManager.access$getDrivers$p(this.this$0).add(this.$driver);
                CryptoDevManager.access$setScanning$p(this.this$0, false);
            }
            {
                this.this$0 = cryptoDevManager;
                this.$driver = iDevDriver;
            }
        });
    }

    public final void unregisterDriver(@NotNull String driverName) {
        Intrinsics.checkParameterIsNotNull((Object)driverName, (String)"driverName");
        this.myHandler.post(new Runnable(this, driverName){
            final /* synthetic */ CryptoDevManager this$0;
            final /* synthetic */ String $driverName;

            public final void run() {
                CryptoDevManager.access$setDestroying$p(this.this$0, true);
                IDevDriver driver = null;
                for (IDevDriver drv : CryptoDevManager.access$getDrivers$p(this.this$0)) {
                    if (!Intrinsics.areEqual((Object)drv.getDriverName(), (Object)this.$driverName)) continue;
                    driver = drv;
                }
                if (driver == null) {
                    Log.e((String)"CryptoDevManager", (String)("Driver " + this.$driverName + " not exist!"));
                    CryptoDevManager.access$setDestroying$p(this.this$0, false);
                    return;
                }
                Iterator<E> iterator = CryptoDevManager.access$getDevList$p(this.this$0).iterator();
                Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"devList.iterator()");
                Iterator<E> devIterator = iterator;
                while (devIterator.hasNext()) {
                    CryptoDevInfo devInfo = (CryptoDevInfo)devIterator.next();
                    if (!Intrinsics.areEqual((Object)devInfo.getDriver(), (Object)driver.getDriverName())) continue;
                    devIterator.remove();
                }
                CryptoDevManager cryptoDevManager = CryptoDevManager.access$getManager$cp();
                if (cryptoDevManager == null) {
                    Intrinsics.throwNpe();
                }
                driver.unregisterDevChangedListener(cryptoDevManager);
                driver.destroy();
                CryptoDevManager.access$getDrivers$p(this.this$0).remove(driver);
                CryptoDevManager.access$setDestroying$p(this.this$0, false);
            }
            {
                this.this$0 = cryptoDevManager;
                this.$driverName = string;
            }
        });
    }

    public final void destroy() {
        Iterable $this$forEach$iv = this.drivers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IDevDriver it = (IDevDriver)element$iv;
            boolean bl = false;
            this.unregisterDriver(it.getDriverName());
        }
    }

    public final int getDevCount() {
        return ((Number)this.runAfterDeviceCheck((Function0)new Function0<Integer>(this){
            final /* synthetic */ CryptoDevManager this$0;

            public final int invoke() {
                return CryptoDevManager.access$getDevList$p(this.this$0).size();
            }
            {
                this.this$0 = cryptoDevManager;
                super(0);
            }
        })).intValue();
    }

    @NotNull
    public final List<CryptoDevInfo> getCryptoDevInfos() {
        return (List)this.runAfterDeviceCheck((Function0)new Function0<Vector<CryptoDevInfo>>(this){
            final /* synthetic */ CryptoDevManager this$0;

            @NotNull
            public final Vector<CryptoDevInfo> invoke() {
                return CryptoDevManager.access$getDevList$p(this.this$0);
            }
            {
                this.this$0 = cryptoDevManager;
                super(0);
            }
        });
    }

    @Nullable
    public final CryptoInstance createInstance(@Nullable CryptoDevFactory factory, @Nullable CryptoDevType type) {
        return (CryptoInstance)this.runAfterDeviceCheck((Function0)new Function0<CryptoInstance>(this, factory, type){
            final /* synthetic */ CryptoDevManager this$0;
            final /* synthetic */ CryptoDevFactory $factory;
            final /* synthetic */ CryptoDevType $type;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final CryptoInstance invoke() {
                void var1_1;
                if (this.$factory == null && this.$type == null) {
                    Log.e((String)"CryptoDevManager", (String)"factory && type == null");
                    return null;
                }
                CryptoInstance instance = null;
                for (CryptoDevInfo devInfo : CryptoDevManager.access$getDevList$p(this.this$0)) {
                    if (devInfo == null || devInfo.getFactory() != this.$factory || devInfo.getType() != this.$type) continue;
                    instance = this.this$0.createInstance(devInfo);
                }
                return var1_1;
            }
            {
                this.this$0 = cryptoDevManager;
                this.$factory = cryptoDevFactory;
                this.$type = cryptoDevType;
                super(0);
            }
        });
    }

    @Nullable
    public final CryptoInstance createInstance(@Nullable String driver, @Nullable CryptoDevType type) {
        return (CryptoInstance)this.runAfterDeviceCheck((Function0)new Function0<CryptoInstance>(this, driver, type){
            final /* synthetic */ CryptoDevManager this$0;
            final /* synthetic */ String $driver;
            final /* synthetic */ CryptoDevType $type;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final CryptoInstance invoke() {
                void var1_1;
                if (this.$driver == null && this.$type == null) {
                    Log.e((String)"CryptoDevManager", (String)"driver && type == null");
                    return null;
                }
                CryptoInstance instance = null;
                for (CryptoDevInfo devInfo : CryptoDevManager.access$getDevList$p(this.this$0)) {
                    if (devInfo == null || !Intrinsics.areEqual((Object)devInfo.getDriver(), (Object)this.$driver) || devInfo.getType() != this.$type) continue;
                    instance = this.this$0.createInstance(devInfo);
                }
                return var1_1;
            }
            {
                this.this$0 = cryptoDevManager;
                this.$driver = string;
                this.$type = cryptoDevType;
                super(0);
            }
        });
    }

    @Nullable
    public final CryptoInstance createInstance(@Nullable CryptoDevInfo info) {
        return (CryptoInstance)this.runAfterDeviceCheck((Function0)new Function0<CryptoInstance>(this, info){
            final /* synthetic */ CryptoDevManager this$0;
            final /* synthetic */ CryptoDevInfo $info;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final CryptoInstance invoke() {
                void var1_1;
                if (this.$info == null) {
                    Log.e((String)"CryptoDevManager", (String)"param crypto dev info == null");
                    return null;
                }
                CryptoInstance instance = null;
                for (IDevDriver driver : CryptoDevManager.access$getDrivers$p(this.this$0)) {
                    if (!Intrinsics.areEqual((Object)driver.getDriverName(), (Object)this.$info.getDriver())) continue;
                    instance = driver.getInstance(this.$info);
                }
                return var1_1;
            }
            {
                this.this$0 = cryptoDevManager;
                this.$info = cryptoDevInfo;
                super(0);
            }
        });
    }

    @Nullable
    public final CryptoInstance createInstance(@Nullable String cardId) {
        return (CryptoInstance)this.runAfterDeviceCheck((Function0)new Function0<CryptoInstance>(this, cardId){
            final /* synthetic */ CryptoDevManager this$0;
            final /* synthetic */ String $cardId;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final CryptoInstance invoke() {
                void var1_1;
                if (TextUtils.isEmpty((CharSequence)this.$cardId)) {
                    Log.e((String)"CryptoDevManager", (String)"Param card id = null");
                    return null;
                }
                CryptoInstance instance = null;
                for (CryptoDevInfo devInfo : CryptoDevManager.access$getDevList$p(this.this$0)) {
                    if (!Intrinsics.areEqual((Object)devInfo.getCardId(), (Object)this.$cardId)) continue;
                    instance = this.this$0.createInstance(devInfo);
                }
                return var1_1;
            }
            {
                this.this$0 = cryptoDevManager;
                this.$cardId = string;
                super(0);
            }
        });
    }

    @Override
    public void onDriverRefreshed(@NotNull IDevDriver driver) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Log.d((String)THIS_FILE, (String)("driver " + driver.getDriverName() + " device changed. Refresh dev list"));
        Iterator<CryptoDevInfo> iterator = this.devList.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"devList.iterator()");
        Iterator<CryptoDevInfo> devIter = iterator;
        while (devIter.hasNext()) {
            CryptoDevInfo devInfo = devIter.next();
            if (!Intrinsics.areEqual((Object)devInfo.getDriver(), (Object)driver.getDriverName())) continue;
            devIter.remove();
        }
        this.devList.addAll((Collection<CryptoDevInfo>)driver.getDevInfos());
        Log.d((String)THIS_FILE, (String)("Current has " + this.devList.size() + " device in system"));
    }

    @Override
    public void onDriverDeviceAdded(@NotNull CryptoDevInfo devInfo) {
        Intrinsics.checkParameterIsNotNull((Object)devInfo, (String)"devInfo");
        try {
            Object object = devInfo.clone();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.xdja.cryptodev.CryptoDevInfo");
            }
            this.devList.add((CryptoDevInfo)object);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        Log.d((String)THIS_FILE, (String)"Start to schedule handler task --> Device Added Event");
        this.myHandler.post(new Runnable(this, devInfo){
            final /* synthetic */ CryptoDevManager this$0;
            final /* synthetic */ CryptoDevInfo $devInfo;

            public final void run() {
                Log.d((String)"CryptoDevManager", (String)(this.$devInfo.getType().getComment() + "\u589e\u52a0\uff0c\u5361\u53f7\uff1a" + this.$devInfo.getCardId()));
                CryptoDevManager.access$notifyDeviceAdded(this.this$0, this.$devInfo.getDriver(), this.$devInfo.getType(), this.$devInfo.getCardId());
            }
            {
                this.this$0 = cryptoDevManager;
                this.$devInfo = cryptoDevInfo;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void notifyDeviceAdded(String driver, CryptoDevType devType, String cardId) {
        Log.d((String)THIS_FILE, (String)("Device Added: Device listener list size " + this.deviceListeners.size()));
        int n = 0;
        int n2 = ((Collection)this.deviceListeners).size();
        while (n < n2) {
            DeviceListener listener;
            void index;
            Intrinsics.checkExpressionValueIsNotNull((Object)this.deviceListeners.get((int)index), (String)"deviceListeners[index]");
            if (listener != null) {
                Log.d((String)THIS_FILE, (String)("Start to call device added listener --> " + listener));
                listener.onDeviceAdded(driver, devType, cardId);
            }
            ++index;
        }
    }

    @Override
    public void onDriverDeviceRemoved(@NotNull CryptoDevInfo devInfo) {
        Intrinsics.checkParameterIsNotNull((Object)devInfo, (String)"devInfo");
        Iterator<CryptoDevInfo> iterator = this.devList.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"devList.iterator()");
        Iterator<CryptoDevInfo> devIter = iterator;
        while (devIter.hasNext()) {
            CryptoDevInfo info = devIter.next();
            if (!Intrinsics.areEqual((Object)info.getCardId(), (Object)devInfo.getCardId())) continue;
            devIter.remove();
        }
        Log.d((String)THIS_FILE, (String)"Start to schedule handler task --> Device Removed Event");
        this.myHandler.post(new Runnable(this, devInfo){
            final /* synthetic */ CryptoDevManager this$0;
            final /* synthetic */ CryptoDevInfo $devInfo;

            public final void run() {
                Log.d((String)"CryptoDevManager", (String)(this.$devInfo.getType().getComment() + "\u79fb\u9664\uff0c\u5361\u53f7\uff1a" + this.$devInfo.getCardId()));
                Log.d((String)"CryptoDevManager", (String)("Device Removed: Device listener list size " + CryptoDevManager.access$getDeviceListeners$p(this.this$0).size()));
                Iterator<E> iterator = CryptoDevManager.access$getDeviceListeners$p(this.this$0).iterator();
                Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"deviceListeners.iterator()");
                Iterator<E> listenerIterator = iterator;
                while (listenerIterator.hasNext()) {
                    DeviceListener listener = (DeviceListener)listenerIterator.next();
                    Log.d((String)"CryptoDevManager", (String)("Start to call device removed listener --> " + listener));
                    listener.onDeviceRemoved(this.$devInfo.getDriver(), this.$devInfo.getType(), this.$devInfo.getCardId());
                }
            }
            {
                this.this$0 = cryptoDevManager;
                this.$devInfo = cryptoDevInfo;
            }
        });
    }

    @Override
    public void onDriverDeviceAdded(@NotNull IDevDriver driver, @NotNull CryptoDevType devType, @NotNull String cardId) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull((Object)devType, (String)"devType");
        Intrinsics.checkParameterIsNotNull((Object)cardId, (String)"cardId");
        CryptoDevInfo devInfo = new CryptoDevInfo();
        devInfo.setDriver(driver.getDriverName());
        devInfo.setType(devType);
        devInfo.setCardId(cardId);
        devInfo.setFactory(CryptoDevFactory.FACTORY_XDJA);
        this.devList.add(devInfo);
        this.myHandler.post(new Runnable(this, devType, cardId, driver){
            final /* synthetic */ CryptoDevManager this$0;
            final /* synthetic */ CryptoDevType $devType;
            final /* synthetic */ String $cardId;
            final /* synthetic */ IDevDriver $driver;

            public final void run() {
                Log.d((String)"CryptoDevManager", (String)(this.$devType.getComment() + "\u589e\u52a0\uff0c\u5361\u53f7\uff1a" + this.$cardId));
                CryptoDevManager.access$notifyDeviceAdded(this.this$0, this.$driver.getDriverName(), this.$devType, this.$cardId);
            }
            {
                this.this$0 = cryptoDevManager;
                this.$devType = cryptoDevType;
                this.$cardId = string;
                this.$driver = iDevDriver;
            }
        });
    }

    @Override
    public void onDriverDeviceRemoved(@NotNull IDevDriver driver, @NotNull CryptoDevType devType, @NotNull String cardId) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull((Object)devType, (String)"devType");
        Intrinsics.checkParameterIsNotNull((Object)cardId, (String)"cardId");
        Iterator<CryptoDevInfo> iterator = this.devList.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"devList.iterator()");
        Iterator<CryptoDevInfo> devIter = iterator;
        while (devIter.hasNext()) {
            CryptoDevInfo devInfo = devIter.next();
            if (!Intrinsics.areEqual((Object)devInfo.getCardId(), (Object)cardId)) continue;
            devIter.remove();
        }
        this.myHandler.post(new Runnable(this, devType, cardId, driver){
            final /* synthetic */ CryptoDevManager this$0;
            final /* synthetic */ CryptoDevType $devType;
            final /* synthetic */ String $cardId;
            final /* synthetic */ IDevDriver $driver;

            public final void run() {
                Log.d((String)"CryptoDevManager", (String)(this.$devType.getComment() + "\u79fb\u9664\uff0c\u5361\u53f7\uff1a" + this.$cardId));
                Iterator<E> iterator = CryptoDevManager.access$getDeviceListeners$p(this.this$0).iterator();
                Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"deviceListeners.iterator()");
                Iterator<E> listenerIterator = iterator;
                while (listenerIterator.hasNext()) {
                    DeviceListener listener = (DeviceListener)listenerIterator.next();
                    listener.onDeviceRemoved(this.$driver.getDriverName(), this.$devType, this.$cardId);
                }
            }
            {
                this.this$0 = cryptoDevManager;
                this.$devType = cryptoDevType;
                this.$cardId = string;
                this.$driver = iDevDriver;
            }
        });
    }

    private CryptoDevManager() {
        Log.d((String)THIS_FILE, (String)"Call CryptoDevManager init---");
        this.handlerThread.setPriority(10);
        this.handlerThread.start();
        this.myHandler = new Handler(this.handlerThread.getLooper());
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ boolean access$isScanning$p(CryptoDevManager $this) {
        return $this.isScanning;
    }

    public static final /* synthetic */ void access$setScanning$p(CryptoDevManager $this, boolean bl) {
        $this.isScanning = bl;
    }

    public static final /* synthetic */ Vector access$getDevList$p(CryptoDevManager $this) {
        return $this.devList;
    }

    public static final /* synthetic */ ArrayList access$getDrivers$p(CryptoDevManager $this) {
        return $this.drivers;
    }

    public static final /* synthetic */ boolean access$isDestroying$p(CryptoDevManager $this) {
        return $this.isDestroying;
    }

    public static final /* synthetic */ void access$setDestroying$p(CryptoDevManager $this, boolean bl) {
        $this.isDestroying = bl;
    }

    public static final /* synthetic */ void access$notifyDeviceAdded(CryptoDevManager $this, String driver, CryptoDevType devType, String cardId) {
        $this.notifyDeviceAdded(driver, devType, cardId);
    }

    public static final /* synthetic */ ArrayList access$getDeviceListeners$p(CryptoDevManager $this) {
        return $this.deviceListeners;
    }

    public /* synthetic */ CryptoDevManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @NotNull
    public static final synchronized CryptoDevManager getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    public static final boolean inDevList(@Nullable List<? extends CryptoDevInfo> devInfos, @NotNull String cardId) {
        return Companion.inDevList(devInfos, cardId);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/xdja/cryptodev/CryptoDevManager$Companion;", "", "()V", "THIS_FILE", "", "instance", "Lcom/xdja/cryptodev/CryptoDevManager;", "instance$annotations", "getInstance", "()Lcom/xdja/cryptodev/CryptoDevManager;", "manager", "inDevList", "", "devInfos", "", "Lcom/xdja/cryptodev/CryptoDevInfo;", "cardId", "crypto_release"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void instance$annotations() {
        }

        @NotNull
        public final synchronized CryptoDevManager getInstance() {
            if (manager == null) {
                manager = new CryptoDevManager(null);
                CryptoDevManager cryptoDevManager = manager;
                if (cryptoDevManager == null) {
                    Intrinsics.throwNpe();
                }
                cryptoDevManager.registerError(new XdjaError());
                CryptoDevManager cryptoDevManager2 = manager;
                if (cryptoDevManager2 == null) {
                    Intrinsics.throwNpe();
                }
                cryptoDevManager2.registerError(new ChipManagerError());
                CryptoDevManager cryptoDevManager3 = manager;
                if (cryptoDevManager3 == null) {
                    Intrinsics.throwNpe();
                }
                cryptoDevManager3.registerError(new KoalError());
                CryptoDevManager cryptoDevManager4 = manager;
                if (cryptoDevManager4 == null) {
                    Intrinsics.throwNpe();
                }
                cryptoDevManager4.registerError(new SkfError());
            }
            CryptoDevManager cryptoDevManager = manager;
            if (cryptoDevManager == null) {
                Intrinsics.throwNpe();
            }
            return cryptoDevManager;
        }

        @JvmStatic
        public final boolean inDevList(@Nullable List<? extends CryptoDevInfo> devInfos, @NotNull String cardId) {
            Intrinsics.checkParameterIsNotNull((Object)cardId, (String)"cardId");
            if (devInfos != null) {
                for (CryptoDevInfo cryptoDevInfo : devInfos) {
                    if (!Intrinsics.areEqual((Object)cardId, (Object)cryptoDevInfo.getCardId())) continue;
                    return true;
                }
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

