/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptodev.devapi;

import android.util.Log;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.devapi.CommonInterface;
import com.xdja.cryptodev.devapi.IDevStateListener;
import com.xdja.cryptodev.devapi.SKFInterface;
import com.xdja.cryptodev.devapi.XdjaCommonInterface;
import com.xdja.cryptodev.driver.IDevDriver;
import com.xdja.cryptodev.driver.xdja.IFid;
import com.xdja.cryptodev.exception.CryptoDevException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 '2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001'B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0017J\u0006\u0010\u001e\u001a\u00020\u001bJ\u000e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u0019J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0017R\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/xdja/cryptodev/devapi/CryptoInstance;", "Lcom/xdja/cryptodev/devapi/CommonInterface;", "Lcom/xdja/cryptodev/devapi/XdjaCommonInterface;", "Lcom/xdja/cryptodev/devapi/SKFInterface;", "driver", "Lcom/xdja/cryptodev/driver/IDevDriver;", "devInfo", "Lcom/xdja/cryptodev/CryptoDevInfo;", "(Lcom/xdja/cryptodev/driver/IDevDriver;Lcom/xdja/cryptodev/CryptoDevInfo;)V", "cardId", "", "getCardId", "()Ljava/lang/String;", "getDevInfo", "()Lcom/xdja/cryptodev/CryptoDevInfo;", "setDevInfo", "(Lcom/xdja/cryptodev/CryptoDevInfo;)V", "getDriver", "()Lcom/xdja/cryptodev/driver/IDevDriver;", "setDriver", "(Lcom/xdja/cryptodev/driver/IDevDriver;)V", "listeners", "Ljava/util/ArrayList;", "Lcom/xdja/cryptodev/devapi/IDevStateListener;", "refCnt", "", "addRef", "", "addStateListener", "listener", "destroy", "onError", "code", "readCert", "Ljava/security/cert/Certificate;", "containNo", "fid", "Lcom/xdja/cryptodev/driver/xdja/IFid;", "removeStateListener", "Companion", "crypto_release"})
public abstract class CryptoInstance
implements CommonInterface,
XdjaCommonInterface,
SKFInterface {
    private int refCnt;
    private final ArrayList<IDevStateListener> listeners;
    @NotNull
    private IDevDriver driver;
    @NotNull
    private CryptoDevInfo devInfo;
    private static final String THIS_FILE = "CryptoDev";
    public static final Companion Companion = new Companion(null);

    public final synchronized void addStateListener(@NotNull IDevStateListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    public final synchronized void removeStateListener(@NotNull IDevStateListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    @Nullable
    public final String getCardId() {
        return this.devInfo.getCardId();
    }

    public final void onError(int code) {
        for (IDevStateListener listener : this.listeners) {
            listener.onDevError(code);
        }
    }

    public final void destroy() {
        CryptoInstance cryptoInstance = this;
        cryptoInstance.refCnt += -1;
        if (cryptoInstance.refCnt == 0) {
            Log.d((String)THIS_FILE, (String)"Refernce count is 0, destroy instance");
            this.listeners.clear();
            this.driver.getCryptoDevs().remove(this);
            return;
        }
        Log.d((String)THIS_FILE, (String)("Refernce count is " + this.refCnt));
    }

    public final void addRef() {
        CryptoInstance cryptoInstance = this;
        ++cryptoInstance.refCnt;
        int cfr_ignored_0 = cryptoInstance.refCnt;
        Log.d((String)THIS_FILE, (String)("Refernce count is " + this.refCnt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Certificate readCert(int containNo, @NotNull IFid fid) throws CryptoDevException, CertificateException {
        Certificate certificate;
        block7: {
            boolean bl;
            Object object;
            byte[] cert_buf;
            block9: {
                block8: {
                    Intrinsics.checkParameterIsNotNull((Object)fid, (String)"fid");
                    cert_buf = new byte[2048];
                    int[] certLen = new int[1];
                    byte[] fidArray = fid.getFid(containNo);
                    int result = this.readCert(fidArray, cert_buf, certLen);
                    if (result != 0) break block7;
                    object = fidArray;
                    bl = false;
                    if (((byte[])object).length == 0) break block8;
                    object = cert_buf;
                    bl = false;
                    if (((byte[])object).length == 0) break block8;
                    object = certLen;
                    bl = false;
                    if (!(((byte[])object).length == 0)) break block9;
                }
                throw (Throwable)new CryptoDevException(" fidArray or cert_buf or certLen is invalid");
            }
            object = new ByteArrayInputStream(cert_buf);
            bl = false;
            Throwable throwable = null;
            try {
                ByteArrayInputStream it = (ByteArrayInputStream)object;
                boolean bl2 = false;
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Certificate certificate2 = cf.generateCertificate(it);
                certificate = certificate2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        throw (Throwable)new CryptoDevException(" read cert error");
        Intrinsics.checkExpressionValueIsNotNull((Object)certificate, (String)"if (fidArray.isEmpty() |\u2026          }\n            }");
        return certificate;
    }

    @NotNull
    protected final IDevDriver getDriver() {
        return this.driver;
    }

    protected final void setDriver(@NotNull IDevDriver iDevDriver) {
        Intrinsics.checkParameterIsNotNull((Object)iDevDriver, (String)"<set-?>");
        this.driver = iDevDriver;
    }

    @NotNull
    public final CryptoDevInfo getDevInfo() {
        return this.devInfo;
    }

    public final void setDevInfo(@NotNull CryptoDevInfo cryptoDevInfo) {
        Intrinsics.checkParameterIsNotNull((Object)cryptoDevInfo, (String)"<set-?>");
        this.devInfo = cryptoDevInfo;
    }

    public CryptoInstance(@NotNull IDevDriver driver, @NotNull CryptoDevInfo devInfo) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull((Object)devInfo, (String)"devInfo");
        this.driver = driver;
        this.devInfo = devInfo;
        this.listeners = new ArrayList();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/xdja/cryptodev/devapi/CryptoInstance$Companion;", "", "()V", "THIS_FILE", "", "crypto_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

