/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptodev.driver;

import android.util.Log;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.cryptodev.driver.DriverDevChangedListener;
import java.util.ArrayList;
import java.util.Vector;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\b&\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u000eH&J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u000eJ\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u000eJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u000eJ\b\u0010\u001c\u001a\u00020\u001dH&J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\fJ\u000e\u0010!\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\fR \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0007\"\u0004\b\u0010\u0010\tR\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/xdja/cryptodev/driver/IDevDriver;", "", "()V", "cryptoDevs", "Ljava/util/Vector;", "Lcom/xdja/cryptodev/devapi/CryptoInstance;", "getCryptoDevs", "()Ljava/util/Vector;", "setCryptoDevs", "(Ljava/util/Vector;)V", "devChangedListeners", "Ljava/util/ArrayList;", "Lcom/xdja/cryptodev/driver/DriverDevChangedListener;", "devInfos", "Lcom/xdja/cryptodev/CryptoDevInfo;", "getDevInfos", "setDevInfos", "driverName", "", "getDriverName", "()Ljava/lang/String;", "createInstance", "devInfo", "destroy", "", "deviceAdded", "deviceRemoved", "getInstance", "init", "", "refresh", "registerDevChangedListener", "listener", "unregisterDevChangedListener", "Companion", "crypto_release"})
public abstract class IDevDriver {
    @NotNull
    private Vector<CryptoDevInfo> devInfos = new Vector();
    @NotNull
    private Vector<CryptoInstance> cryptoDevs = new Vector();
    private ArrayList<DriverDevChangedListener> devChangedListeners = new ArrayList();
    private static final String THIS_FILE = "IDevDriver";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Vector<CryptoDevInfo> getDevInfos() {
        return this.devInfos;
    }

    public final void setDevInfos(@NotNull Vector<CryptoDevInfo> vector) {
        Intrinsics.checkParameterIsNotNull(vector, (String)"<set-?>");
        this.devInfos = vector;
    }

    @NotNull
    public final Vector<CryptoInstance> getCryptoDevs() {
        return this.cryptoDevs;
    }

    public final void setCryptoDevs(@NotNull Vector<CryptoInstance> vector) {
        Intrinsics.checkParameterIsNotNull(vector, (String)"<set-?>");
        this.cryptoDevs = vector;
    }

    @NotNull
    public abstract String getDriverName();

    public abstract int init();

    public int refresh() {
        for (DriverDevChangedListener listener : this.devChangedListeners) {
            listener.onDriverRefreshed(this);
        }
        return 0;
    }

    public final void deviceAdded(@NotNull CryptoDevInfo devInfo) {
        Intrinsics.checkParameterIsNotNull((Object)devInfo, (String)"devInfo");
        for (DriverDevChangedListener listener : this.devChangedListeners) {
            listener.onDriverDeviceAdded(devInfo);
        }
    }

    public final void deviceRemoved(@NotNull CryptoDevInfo devInfo) {
        Intrinsics.checkParameterIsNotNull((Object)devInfo, (String)"devInfo");
        for (DriverDevChangedListener listener : this.devChangedListeners) {
            listener.onDriverDeviceRemoved(devInfo);
        }
    }

    @Nullable
    public abstract CryptoInstance createInstance(@NotNull CryptoDevInfo var1);

    public final void registerDevChangedListener(@NotNull DriverDevChangedListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.devChangedListeners.add(listener);
    }

    public final void unregisterDevChangedListener(@NotNull DriverDevChangedListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.devChangedListeners.remove(listener);
    }

    public void destroy() {
        this.devInfos.clear();
        for (CryptoInstance cryptoDev : this.cryptoDevs) {
            cryptoDev.close();
        }
        this.cryptoDevs.clear();
    }

    @Nullable
    public final CryptoInstance getInstance(@NotNull CryptoDevInfo devInfo) {
        CryptoInstance dev2;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)devInfo, (String)"devInfo");
            Log.d((String)THIS_FILE, (String)("Try to get instance " + devInfo));
            for (CryptoInstance dev2 : this.cryptoDevs) {
                if (!Intrinsics.areEqual((Object)devInfo.getCardId(), (Object)dev2.getDevInfo().getCardId())) continue;
                Log.d((String)THIS_FILE, (String)"Instance already created. Just add ref and return it ");
                dev2.addRef();
                return dev2;
            }
            Log.d((String)THIS_FILE, (String)"Need to create new instance");
            CryptoInstance cryptoInstance = dev2 = this.createInstance(devInfo);
            if (cryptoInstance == null) break block1;
            cryptoInstance.addRef();
        }
        return dev2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/xdja/cryptodev/driver/IDevDriver$Companion;", "", "()V", "THIS_FILE", "", "crypto_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

